% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pts_pop_pc}
\alias{pts_pop_pc}
\title{pts_pop_pc : details on Setophaga plumbea populations}
\format{An object of class 'data.frame' with the following columns :
\describe{
\item{id}{Population ID of the 20 populations, as used during the sampling
stage}
\item{Longitude}{Sampling site (population) longitude (WGS 84)}
\item{Latitude}{Sampling site (population) latitude (WGS 84)}
\item{loc}{Character string indicating whether the population is located
on "Basse-Terre" (BT) or on "Grande-Terre" (GT) (2 main Guadeloupe islands)}
\item{id_publi}{Population ID of the 20 populations, as used in the
paper of Khimoun et al. (2017).}
}}
\source{
\url{https://datadryad.org/resource/doi:10.5061/dryad.v8324}
There are as many rows as there are sampled populations.
In the genetic dataset, some populations were removed, and other were
grouped, based on location and numbers of sampled individuals.
}
\usage{
pts_pop_pc
}
\description{
Setophaga plumbea dataset
Data from French Guadeloupe
20 populations sampled by A. Khimoun and S. Garnier
}
\examples{
data("pts_pop_pc")
str(pts_pop_pc)
}
\references{
\insertRef{khimoun2017landscape}{graph4lg}
}
\keyword{datasets}
