% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_graph_indep.R
\name{gen_graph_indep}
\alias{gen_graph_indep}
\title{Create an independence graph of genetic differentiation
from genetic data of class genind}
\usage{
gen_graph_indep(
  x,
  dist = "basic",
  cov = "sq",
  pcor = "magwene",
  alpha = 0.05,
  test = "EED",
  adj = "none",
  output = "igraph"
)
}
\arguments{
\item{x}{An object of class \code{genind} that contains the multilocus
genotype (format 'locus') of the individuals as well as their population
and their geographical coordinates.}

\item{dist}{A character string indicating the method used to compute the
multilocus genetic distance between populations
\itemize{
\item{If 'dist = 'basic'' (default), then the multilocus genetic distance is
computed using a Euclidean genetic distance formula (Excoffier et al., 1992)}
\item{If 'dist = 'weight'', then the multilocus genetic distance is computed
as in Fortuna et al. (2009). It is a Euclidean genetic distance giving more
weight to rare alleles}
\item{If 'dist = 'PG'', then the multilocus genetic distance is computed as
in popgraph::popgraph function, following several steps of PCA and SVD
(Dyer et Nason, 2004).}
\item{If 'dist = 'PCA'', then the genetic distance is computed following a
PCA of the matrix of allelic frequencies by population. It is a Euclidean
genetic distance between populations in the multidimensional space defined
by all the independent principal components.}
}}

\item{cov}{A character string indicating the formula used to compute the
covariance matrix from the distance matrix
\itemize{
\item{If 'cov = 'sq'' (default), then the covariance matrix is calculated
from the matrix of squared distances as in Everitt et Hothorn (2011)}
\item{If 'cov = 'dist'', then the covariance matrix is calculated from the
matrix of distances as in Dyer et Nason (2004) and popgraph function}
}}

\item{pcor}{A character string indicating the way the partial correlation
matrix is computed from the covariance matrix.
\itemize{
\item{If 'pcor = 'magwene'', the steps followed are the same as in
Magwene (2001) and in popgraph::popgraph function. It is the recommended
option as it meets mathematical requirements.}
\item{If 'pcor = 'other'', the steps followed are the same as used
by Fortuna et al. (2009). They are not consistent with the approach
of Magwene (2001).}
}}

\item{alpha}{A numeric value corresponding to the statistical tolerance
threshold used to test the difference from 0 of the partial correlation
coefficients. By default, 'alpha=0.05'.}

\item{test}{A character string indicating the method used to test the
significance of the partial correlation coefficients.
\itemize{
\item{If 'test = 'EED'' (default), then the Edge Exclusion Deviance
criterion is used (Whittaker, 2009). Although other methods exist, this is
the most common and thus the only one implemented here.}
}}

\item{adj}{A character string indicating the way of adjusting p-values to
assess the significance of the p-values
\itemize{
\item{If 'adj = 'none'' (default), there is no p-value adjustment correction}
\item{If 'adj = 'holm'', p-values are adjusted using the sequential
Bonferroni correction (Holm, 1979)}
\item{If 'adj = 'bonferroni'', p-values are adjusted using the classic
Bonferroni correction}
\item{If 'adj = 'BH'', p-values are adjusted using Benjamini et Hochberg
(1995) correction controlling false discovery rate}
}}

\item{output}{A character string indicating the matrices included in
the output list.
\itemize{
\item{If 'output = 'all'' (default), then D (distance matrix),
C (covariance matrix), Rho (partial correlation matrix),
M (graph incidence matrix) and S (strength matrix) are included}
\item{If 'output = 'dist_graph'', then the distance matrix D is returned
only with the values corresponding to the graph edges}
\item{If 'output = 'str_graph'', then the strength values matrix S is
returned only with the values corresponding to the graph edges}
\item{If 'output = 'inc'', then the binary adjacency matrix M is returned}
\item{If 'output = 'igraph'', then a graph of class \code{igraph}
is returned}
}}
}
\value{
A \code{list} of objects of class \code{matrix}, an object of
class \code{matrix} or a graph object of class \code{igraph}
}
\description{
The function allows to create genetic graphs from genetic data
by applying the conditional independence principle. Populations whose allelic
frequencies covary significantly once the covariance with the other
populations has been taken into account are linked on the graphs.
}
\details{
The function allows to vary many parameters such as the genetic
distance used, the formula used to compute the covariance, the statistical
tolerance threshold, the p-values adjustment, among others.
}
\examples{
data(data_pc_genind)
dist_graph_test <- gen_graph_indep(x = data_pc_genind, dist = "basic",
                             cov = "sq", pcor = "magwene",
                             alpha = 0.05, test = "EED",
                             adj = "none", output = "igraph")
}
\references{
\insertRef{dyer2004population}{graph4lg}
\insertRef{benjamini1995controlling}{graph4lg}
\insertRef{bowcock1994high}{graph4lg}
\insertRef{everitt2011introduction}{graph4lg}
\insertRef{excoffier1992analysis}{graph4lg}
\insertRef{fortuna2009networks}{graph4lg}
\insertRef{holm1979simple}{graph4lg}
\insertRef{magwene2001new}{graph4lg}
\insertRef{wermuth1977algorithm}{graph4lg}
\insertRef{whittaker2009graphical}{graph4lg}
}
\author{
P. Savary
}
