% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxicity.R
\name{toxicity}
\alias{toxicity}
\alias{PlotToxicityTestRankAll}
\alias{PlotToxicityTestAll}
\alias{PlotToxicityTestDeferAll}
\alias{PlotToxicityTestRankDeferAll}
\alias{PlotToxicityTestRank}
\alias{PlotToxicityTest}
\title{Perform toxicity tests}
\usage{
PlotToxicityTestRankAll(data, pairs = Findno4sUPairs(data), ...)

PlotToxicityTestAll(data, pairs = Findno4sUPairs(data), ...)

PlotToxicityTestDeferAll(data, pairs = NULL, ...)

PlotToxicityTestRankDeferAll(data, pairs = NULL, ...)

PlotToxicityTestRank(
  data,
  w4sU,
  no4sU = Findno4sUPairs(data)[[w4sU]],
  ntr = w4sU,
  ylim = NULL,
  LFC.fun = lfc::PsiLFC,
  slot = "count",
  correction = 1
)

PlotToxicityTest(
  data,
  w4sU,
  no4sU = Findno4sUPairs(data)[[w4sU]],
  ntr = w4sU,
  ylim = NULL,
  LFC.fun = lfc::PsiLFC,
  slot = "count",
  hl.quantile = 0.8,
  correction = 1
)
}
\arguments{
\item{data}{a grandR object}

\item{pairs}{a no4sU pairs list as generated by \link{Findno4sUPairs}}

\item{...}{further arguments to be passed to or from other methods.}

\item{w4sU}{the name of a 4sU sample}

\item{no4sU}{the name(s) of equivalent no4sU sample(s)}

\item{ntr}{the name of a sample to take NTRs from (usually equal to w4sU)}

\item{ylim}{y axis limits}

\item{LFC.fun}{function to compute log fold change (default: \link[lfc]{PsiLFC}, other viable option: \link[lfc]{NormLFC})}

\item{slot}{the slot of the grandR object to take the data from; for \link[lfc]{PsiLFC}, this really should be "count"!}

\item{correction}{correction factor}

\item{hl.quantile}{the half-life quantile to cut the plot}
}
\value{
either a ggplot object, a list of ggplot objects, or a list of deferred functions for plotting
}
\description{
Testing for toxicity of a 4sU sample is performed by comparing half-lives or NTR ranks against
the log2 fold change of the 4sU sample vs equivalent no4sU samples.
}
\details{
The deferred versions are useful to be used in conjunction with \link{ServeGrandR} plot.static. Their implementation
make sure that they are lightweight, i.e. when saving the returned function to an Rdata file, the grandR object is not stored.
}
\seealso{
\link{Findno4sUPairs},\link{Defer}
}
\concept{toxicity}
