% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lm_predict.R
\name{plot_lm_predict}
\alias{plot_lm_predict}
\title{Plot data and predictions from linear model}
\usage{
plot_lm_predict(
  Model,
  xcol,
  ycol,
  ByFactor,
  obs_size = 2,
  obs_alpha = 0.3,
  pred_size = 2,
  pred_alpha = 0.8,
  linethick,
  base_size = 15,
  ...
)
}
\arguments{
\item{Model}{a linear model saved with \code{simple_model}, \code{mixed_model} or \code{ga_model}.}

\item{xcol}{variable along the X axis (should match one of the dependent variables in model exactly).}

\item{ycol}{independent variable along the Y axis (should match independent variable in model exactly).}

\item{ByFactor}{optional faceting variable (should match one of the variables in model exactly).}

\item{obs_size}{size of symbols for observed data (default = 2).}

\item{obs_alpha}{opacity of symbols for observed data (default = 0.3).}

\item{pred_size}{size of symbols for predicted data (default = 2).}

\item{pred_alpha}{opacity of symbols for predicted data (default = 0.8).}

\item{linethick}{thickness of border lines for boxes and symbols (default is base_size/20).}

\item{base_size}{base fontsize for \code{theme_grafify}}

\item{...}{any other parameters to be passed to \code{theme_grafify}}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a linear model, and up to three variables and plots observe data (circles) and model predictions (squares). If the X-variable is categorical, a box and whiskers plot is overlaid. A variable (\code{ByFactor}) can be used for faceting.
}
\examples{
#fit a model
deathm1 <- mixed_model(data_2w_Tdeath, 
"PI", c("Genotype", "Time"), 
"Experiment")
#plot model
plot_lm_predict(deathm1,
Genotype, PI, Time)
#fit zooplankton data
z1 <- ga_model(data = data_zooplankton,
Y_value = "log(density_adj)",
Fixed_Factor = "taxon",
Smooth_Factor = "day")

#plot fitted data
plot_lm_predict(Model = z1,
xcol = day, 
ycol = `log(density_adj)`,
ByFactor = taxon)

}
