% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-gpuVector.R, R/methods-vclMatrix.R,
%   R/methods-vclVector.R
\docType{methods}
\name{tcrossprod,gpuVector,gpuVector-method}
\alias{tcrossprod,gpuVector,gpuVector-method}
\alias{tcrossprod,gpuVector,missing-method}
\alias{crossprod,vclMatrix,missing-method}
\alias{crossprod,vclMatrix}
\alias{crossprod,vclMatrix,vclMatrix-method}
\alias{crossprod,vclMatrix,matrix-method}
\alias{crossprod,matrix,vclMatrix-method}
\alias{crossprod,vclMatrix,vclVector-method}
\alias{crossprod,vclVector,vclMatrix-method}
\alias{tcrossprod,vclMatrix,missing-method}
\alias{tcrossprod,vclMatrix,vclMatrix-method}
\alias{tcrossprod,matrix,vclMatrix-method}
\alias{tcrossprod,vclMatrix,matrix-method}
\alias{tcrossprod,vclMatrix,vclVector-method}
\alias{tcrossprod,vclVector,vclMatrix-method}
\alias{tcrossprod,vclVector,vclVector-method}
\alias{tcrossprod,vclVector,missing-method}
\title{vclMatrix Crossproduct}
\usage{
\S4method{tcrossprod}{gpuVector,gpuVector}(x, y)

\S4method{tcrossprod}{gpuVector,missing}(x, y)

\S4method{crossprod}{vclMatrix,missing}(x, y)

\S4method{crossprod}{vclMatrix,vclMatrix}(x, y)

\S4method{crossprod}{vclMatrix,matrix}(x, y)

\S4method{crossprod}{matrix,vclMatrix}(x, y)

\S4method{crossprod}{vclMatrix,vclVector}(x, y)

\S4method{crossprod}{vclVector,vclMatrix}(x, y)

\S4method{tcrossprod}{vclMatrix,missing}(x, y)

\S4method{tcrossprod}{vclMatrix,vclMatrix}(x, y)

\S4method{tcrossprod}{matrix,vclMatrix}(x, y)

\S4method{tcrossprod}{vclMatrix,matrix}(x, y)

\S4method{tcrossprod}{vclMatrix,vclVector}(x, y)

\S4method{tcrossprod}{vclVector,vclMatrix}(x, y)

\S4method{tcrossprod}{vclVector,vclVector}(x, y)

\S4method{tcrossprod}{vclVector,missing}(x, y)
}
\arguments{
\item{x}{A \code{vclMatrix} object.}

\item{y}{A \code{vclMatrix} object.}
}
\value{
A \code{vclMatrix} object of the transpose of the outer 
product of the two objects \code{x} and \code{y}.
}
\description{
Return the matrix cross-product of two conformable
matrices using a GPU.  This is equivalent to t(x) %*% y (crossprod)
or x %*% t(y) (tcrossprod) but faster as no data transfer between
device and host is required.
}
\author{
Charles Determan Jr.
}
