% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_prompt.R
\name{text_area_input_wrapper}
\alias{text_area_input_wrapper}
\title{Custom textAreaInput}
\usage{
text_area_input_wrapper(
  inputId,
  label,
  value = "",
  width = NULL,
  height = NULL,
  cols = NULL,
  rows = NULL,
  placeholder = NULL,
  resize = NULL,
  textarea_class = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{height}{The height of the input, e.g. \code{'400px'}, or \code{'100\%'}; see
\code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{cols}{Value of the visible character columns of the input, e.g. \code{80}.
This argument will only take effect if there is not a CSS \code{width} rule
defined for this element; such a rule could come from the \code{width} argument
of this function or from a containing page layout such as
\code{\link[shiny:fluidPage]{fluidPage()}}.}

\item{rows}{The value of the visible character rows of the input, e.g. \code{6}.
If the \code{height} argument is specified, \code{height} will take precedence in the
browser's rendering.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{resize}{Which directions the textarea box can be resized. Can be one of
\code{"both"}, \code{"none"}, \code{"vertical"}, and \code{"horizontal"}. The default, \code{NULL},
will use the client browser's default setting for resizing textareas.}

\item{textarea_class}{Class to be applied to the textarea element}
}
\value{
A modified textAreaInput
}
\description{
Modified version of \code{textAreaInput()} that removes the label container.
It's used in \code{mod_prompt_ui()}
}
