% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpt_queries.R
\name{gpt_edit}
\alias{gpt_edit}
\title{Use GPT to improve text}
\usage{
gpt_edit(
  model,
  instruction,
  temperature,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  append_text = FALSE
)
}
\arguments{
\item{model}{The name of the GPT model to use.}

\item{instruction}{Instruction given to the model on how to improve the text.}

\item{temperature}{A parameter for controlling the randomness of the GPT
model's output.}

\item{openai_api_key}{An API key for the OpenAI API.}

\item{append_text}{Add text to selection rather than replace, defaults to
FALSE}
}
\value{
Nothing is returned. The improved text is inserted into the current
RStudio session.
}
\description{
This function uses the GPT model from OpenAI to improve the spelling and
grammar of the selected text in the current RStudio session.
}
\examples{
# Select some text in Rstudio
# Then call the function as an RStudio addin
\dontrun{
gpt_edit(
  model = "text-davinci-002",
  instruction = "Improve spelling and grammar",
  temperature = 0.5,
  openai_api_key = "my_api_key"
)
}
}
