% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainGPHMM.R
\name{makeGphmmPerRead}
\alias{makeGphmmPerRead}
\title{Create a function to compute gphmm probabilities during the training.}
\usage{
makeGphmmPerRead(seqs, csv)
}
\arguments{
\item{seqs}{- DNAStringSet with DNA sequences used for the training.}

\item{csv}{- data.frame with first column = queries, second column = reference sequences, third column = qv}
}
\description{
\code{makeGphmmPerRead} returns a function to compute gphmm probabilities for each row of the csv file.
}
\examples{
library(Biostrings)
seqs <- DNAStringSet(c(a='ATGC', b = 'ATGG', c = 'ATGT'))
csv <- data.frame(queries = c('a', 'b'), refs = c('c', 'c'))
makeGphmmPerRead(seqs, csv)
}
