% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{predict.GPModel}
\alias{predict.GPModel}
\title{Make predictions for a \code{GPModel}}
\usage{
\method{predict}{GPModel}(object, y = NULL, group_data_pred = NULL,
  group_rand_coef_data_pred = NULL, gp_coords_pred = NULL,
  gp_rand_coef_data_pred = NULL, cluster_ids_pred = NULL,
  predict_cov_mat = FALSE, predict_var = FALSE, cov_pars = NULL,
  X_pred = NULL, use_saved_data = FALSE, vecchia_pred_type = NULL,
  num_neighbors_pred = -1, predict_response = FALSE, ...)
}
\arguments{
\item{object}{a \code{GPModel}}

\item{y}{Observed data (can be NULL, e.g. when the model has been estimated already and the same data is used for making predictions)}

\item{group_data_pred}{A \code{vector} or \code{matrix} with labels of group levels for which predictions are made (if there are grouped random effects in the \code{GPModel})}

\item{group_rand_coef_data_pred}{A \code{vector} or \code{matrix} with covariate data for grouped random coefficients (if there are some in the \code{GPModel})}

\item{gp_coords_pred}{A \code{matrix} with prediction coordinates (features) for Gaussian process (if there is a GP in the \code{GPModel})}

\item{gp_rand_coef_data_pred}{A \code{vector} or \code{matrix} with covariate data for Gaussian process random coefficients (if there are some in the \code{GPModel})}

\item{cluster_ids_pred}{A \code{vector} with IDs / labels indicating the realizations of random effects / Gaussian processes for which predictions are made (set to NULL if you have not specified this when creating the \code{GPModel})}

\item{predict_cov_mat}{A \code{boolean}. If TRUE, the (posterior / conditional) predictive covariance is calculated in addition to the (posterior / conditional) predictive mean}

\item{predict_var}{A \code{boolean}. If TRUE, the (posterior / conditional) predictive variances are calculated}

\item{cov_pars}{A \code{vector} containing covariance parameters (used if the \code{GPModel} has not been trained or if predictions should be made for other parameters than the estimated ones)}

\item{X_pred}{A \code{matrix} with covariate data for the linear regression term (if there is one in the \code{GPModel})}

\item{use_saved_data}{A \code{boolean}. If TRUE, predictions are done using a priory set data via the function '$set_prediction_data'  (this option is not used by users directly)}

\item{vecchia_pred_type}{A \code{string} specifying the type of Vecchia approximation used for making predictions. 
"order_obs_first_cond_obs_only" = observed data is ordered first and the neighbors are only observed points, 
"order_obs_first_cond_all" = observed data is ordered first and the neighbors are selected among all points 
(observed + predicted), "order_pred_first" = predicted data is ordered first for making predictions, 
"latent_order_obs_first_cond_obs_only" = Vecchia approximation for the latent process and observed data is 
ordered first and neighbors are only observed points, "latent_order_obs_first_cond_all" = Vecchia approximation 
for the latent process and observed data is ordered first and neighbors are selected among all points}

\item{num_neighbors_pred}{an \code{integer} specifying the number of neighbors for the Vecchia approximation 
for making predictions}

\item{predict_response}{A \code{boolean}. If TRUE, the response variable (label) is predicted, otherwise the latent random effects (this is only relevant for non-Gaussian data)}

\item{...}{(not used, ignore this, simply here that there is no CRAN warning)}
}
\value{
Predictions made using a \code{GPModel}. It returns a list of length three. 
The first entry ('mu') is the predicted mean, the second entry ('cov') is the predicted covariance matrix 
(=NULL if 'predict_cov_mat=FALSE'), and the third entry ('var') are predicted variances 
(=NULL if 'predict_var=FALSE')
}
\description{
Make predictions for a \code{GPModel}
}
\examples{
# See https://github.com/fabsig/GPBoost/tree/master/R-package for more examples

library(gpboost)
data(GPBoost_data, package = "gpboost")

#--------------------Grouped random effects model: single-level random effect----------------
gp_model <- fitGPModel(group_data = group_data[,1], y = y, likelihood="gaussian",
                       params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_var = TRUE)
pred$mu # Predicted mean
pred$var # Predicted variances
# Also predict covariance matrix
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_cov_mat = TRUE)
pred$mu # Predicted mean
pred$cov # Predicted covariance

\donttest{
#--------------------Gaussian process model----------------
gp_model <- fitGPModel(gp_coords = coords, cov_function = "exponential",
                       likelihood="gaussian", y = y, params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, gp_coords_pred = coords_test, predict_cov_mat = TRUE)
# Predicted (posterior/conditional) mean of GP
pred$mu
# Predicted (posterior/conditional) covariance matrix of GP
pred$cov
}

}
