% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_overlay.R
\name{add_overlay}
\alias{add_overlay}
\title{Add Overlay}
\usage{
add_overlay(
  map,
  north,
  east,
  south,
  west,
  overlay_url,
  layer_id = NULL,
  digits = 4,
  update_map_view = TRUE
)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{north}{northern-most latitude coordinate}

\item{east}{eastern-most longitude}

\item{south}{southern-most latitude coordinate}

\item{west}{western-most longitude}

\item{overlay_url}{URL string specifying the location of the overlay layer}

\item{layer_id}{single value specifying an id for the layer.}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{update_map_view}{logical. Use this parameter to specify if the map should
re-centre according to the overlay extent.}
}
\description{
Adds a ground overlay to a map. The overlay can only be added from a URL
}
\examples{
\dontrun{

map_key <- 'your_api_key'

google_map(key = map_key) \%>\%
  add_overlay(north = 40.773941, south = 40.712216, east = -74.12544, west = -74.22655,
               overlay_url = "https://www.lib.utexas.edu/maps/historical/newark_nj_1922.jpg")


url <- paste0("https://developers.google.com/maps/documentation/javascript",
  "/examples/full/images/talkeetna.png")

google_map(key = map_key) \%>\%
  add_overlay(north = 62.400471, south = 62.281819, east = -150.005608, west = -150.287132,
               overlay_url = url)


}
}
