% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_find.R
\name{sheets_find}
\alias{sheets_find}
\title{Find Google Sheets}
\usage{
sheets_find(...)
}
\arguments{
\item{...}{Arguments (other than \code{type}, which is hard-wired as \code{type = "spreadsheet"}) that are passed along to \code{\link[googledrive:drive_find]{googledrive::drive_find()}}.}
}
\value{
An object of class \code{\link[googledrive]{dribble}}, a tibble with one row per item.
}
\description{
Finds your Google Sheets. This is a very thin wrapper around
\code{\link[googledrive:drive_find]{googledrive::drive_find()}}, that specifies you want to list Drive files
where \code{type = "spreadsheet"}. Therefore, note that this will require auth for
googledrive! See the article \href{https://googlesheets4.tidyverse.org/articles/articles/drive-and-sheets.html}{Using googlesheets4 with googledrive}
if you want to coordinate auth between googlesheets4 and googledrive.
}
\examples{
if (sheets_has_token()) {
  # see all your Sheets
  sheets_find()

  # see 5 Sheets, prioritized by creation time
  x <- sheets_find(order_by = "createdTime desc", n_max = 5)
  x

  # hoist the creation date, using other packages in the tidyverse
  # x \%>\%
  #   tidyr::hoist(drive_resource, created_on = "createdTime") \%>\%
  #   dplyr::mutate(created_on = as.Date(created_on))
}
}
