% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_edit_cells.R
\name{gs_edit_cells}
\alias{gs_edit_cells}
\title{Edit cells}
\usage{
gs_edit_cells(ss, ws = 1, input = "", anchor = "A1", byrow = FALSE,
  col_names = NULL, trim = FALSE, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{input}{new cell values, as an object that can be coerced into a
character vector, presumably an atomic vector, a factor, a matrix or a
data.frame}

\item{anchor}{single character string specifying the upper left cell of the
cell range to edit; positioning notation can be either "A1" or "R1C1"}

\item{byrow}{logical; should we fill cells across a row (\code{byrow =
TRUE}) or down a column (\code{byrow = FALSE}, default); consulted only
when \code{input} is a vector, i.e. \code{dim(input)} is \code{NULL}}

\item{col_names}{logical; indicates whether column names of input should be
included in the edit, i.e. prepended to the input; consulted only when
\code{length(dim(input))} equals 2, i.e. \code{input} is a matrix or
data.frame}

\item{trim}{logical; do you want the worksheet extent to be modified to
correspond exactly to the cells being edited?}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Modify the contents of one or more cells. The cells to be edited are
specified implicitly by a single anchor cell, which will be the upper left
corner of the edited cell region, and the size and shape of the input. If the
input has rectangular shape, i.e. is a data.frame or matrix, then a similarly
shaped range of cells will be updated. If the input has no dimension, i.e.
it's a vector, then \code{byrow} controls whether edited cells will extend
from the anchor across a row or down a column.
}
\examples{
\dontrun{
yo <- gs_new("yo")
yo <- gs_edit_cells(yo, input = head(iris), trim = TRUE)
gs_read(yo)

yo <- gs_ws_new(yo, ws = "byrow_FALSE")
yo <- gs_edit_cells(yo, ws = "byrow_FALSE",
                    input = LETTERS[1:5], anchor = "A8")
gs_read_cellfeed(yo, ws = "byrow_FALSE", range = "A8:A12") \%>\%
  gs_simplify_cellfeed()

yo <- gs_ws_new(yo, ws = "byrow_TRUE")
yo <- gs_edit_cells(yo, ws = "byrow_TRUE", input = LETTERS[1:5],
                    anchor = "A8", byrow = TRUE)
gs_read_cellfeed(yo, ws = "byrow_TRUE", range = "A8:E8") \%>\%
  gs_simplify_cellfeed()

yo <- gs_ws_new(yo, ws = "col_names_FALSE")
yo <- gs_edit_cells(yo, ws = "col_names_FALSE", input = head(iris),
                    trim = TRUE, col_names = FALSE)
gs_read_cellfeed(yo, ws = "col_names_FALSE") \%>\%
  gs_reshape_cellfeed(col_names = FALSE)

gs_delete(yo)
}

}
\seealso{
\code{\link{gs_add_row}}
}
