% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisIntensityMap.R
\name{gvisIntensityMap}
\alias{gvisIntensityMap}
\title{Google Intensity Map with R
\Sexpr{googleChartName <- "intensitymap"}
\Sexpr{gvisChartName <- "gvisIntensityMap"}}
\usage{
gvisIntensityMap(
  data,
  locationvar = "",
  numvar = "",
  options = list(),
  chartid
)
}
\arguments{
\item{data}{a \code{data.frame}. The data has to have at least two columns
with location name (\code{locationvar}) and any number of numeric columns
(\code{numvar}) to be mapped.}

\item{locationvar}{column name of \code{data} with the geo locations to be
analysed. The location has to contain country ISO codes or USA state codes.}

\item{numvar}{column names of \code{data} with the numeric values to be
displayed.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
An intensity map highlights regions or countries based on relative values.
}
\details{
The gvisIntensityMap function reads a data.frame and creates text output
referring to the Google Visualisation API, which can be included into a web
page, or as a stand-alone page.
}
\section{Note}{

Please note that the maximum height for this visualisation is 220 and 
the maximum width is 440. For more details see the Google documentation.

% END DYNAMIC CONTENT
}

\examples{

## Please note that by default the googleVis plot command
## will open a browser window and requires Internet
## connection to display the visualisation.

df=data.frame(country=c("US", "GB", "BR"), val1=c(1,3,4), val2=c(23,12,32))
Intensity1 <- gvisIntensityMap(df, locationvar="country", numvar=c("val1", "val2"))
plot(Intensity1)

## Set colours for each tab
Intensity2 <- gvisIntensityMap(df,
              options=list(colors="['#4682b4', '#0073CF']"))
plot(Intensity2)



}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for printing and
plotting methods, \code{\link{gvisMap}} and \code{\link{gvisGeoMap}} for an
alternative to \code{gvisIntensityMap}.
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\keyword{iplot}
