% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_gce.R
\name{cr_buildstep_compute_container}
\alias{cr_buildstep_compute_container}
\alias{cr_buildstep_compute_rstudio}
\title{Buildstep to deploy to Google Compute Engine}
\usage{
cr_buildstep_compute_container(
  vm_name,
  container_image = "gcr.io/gcer-public/persistent-rstudio:latest",
  disk_name = paste0(vm_name, "-disk"),
  disk_mount_path = "/home",
  zone = "europe-west1-b",
  disk_size = "10GB",
  machine_type = "n1-standard-1",
  container_env = "",
  scopes = "cloud-platform",
  network = "default",
  gcloud_args = NULL
)

cr_buildstep_compute_rstudio(
  rstudio_user,
  rstudio_pw,
  vm_name = "rstudio",
  disk_name = "rstudio-disk",
  zone = "europe-west1-b",
  disk_size = "10GB",
  machine_type = "n1-standard-1",
  container_image = "gcr.io/gcer-public/persistent-rstudio:latest",
  network = "default"
)
}
\arguments{
\item{vm_name}{Name of the VM you will create}

\item{container_image}{The Docker image that will be launched in the VM}

\item{disk_name}{Name of the disk that will be attached to the VM's container image}

\item{disk_mount_path}{Where the disk will be attached to the container in the VM}

\item{zone}{Which zone the VM will launch within}

\item{disk_size}{The size of the disk}

\item{machine_type}{The type of VM that will be launched}

\item{container_env}{Environment variables set within the VM's container image}

\item{scopes}{The GCE scopes that the VM will be launched with permission to use}

\item{network}{The network the VM will use.  The container will bridge into the same network}

\item{gcloud_args}{Other gcloud arguments you send in e.g. \code{c("--boot-disk-device-name=boot-disk1","--boot-disk-size=10GB")}}

\item{rstudio_user}{The usename for the RStudio image the VM will launch}

\item{rstudio_pw}{The password for the RStudio image the VM will launch}
}
\description{
This build step adds some helpers to \link{cr_buildstep_gcloud} for deploying to VMs to GCE that will auto create a container within them and atytach it to the disk
}
\examples{

bs <- cr_buildstep_compute_rstudio("mark", "securepassword1234")
build <- cr_build_yaml(bs)
build
\dontrun{

cr_build(build)
}
}
