% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrollment.R
\name{enrollment}
\alias{enrollment}
\title{Simulate enrollment times}
\usage{
enrollment(lambda = 1, N_total, lambda_time = 0)
}
\arguments{
\item{lambda}{vector. Rate parameter(s) for Poisson distribution.}

\item{N_total}{integer. Value of total sample size.}

\item{lambda_time}{vector. Knots (of \code{length(lambda)}) indicating
regions where a specific hazard rate (\code{lambda}) applies. The first
element is always \code{lambda_time = 0}, denoting the trial start time.
Note: final element of \code{lambda} is assumed to be constant as
\code{lambda_time} tends to infinity.}
}
\value{
A vector of enrollment times (from time of first patient enrollment)
in unit time (e.g. days).
}
\description{
Simulate enrollment time using a piecewise Poisson distribution.
}
\details{
Subject recruitment is assumed to follow a (piecewise stationary)
Poisson process. We assume trial recruitment to be an independent process,
thus the 'memoryless' property modelling of subject recruitment is used.
Since the subject recruitment rate can vary over time, we can account for
differential rates over time. Note that the first trial enrollment is
assumed to occur at time zero.

To illustrate, suppose we use a piecewise function to specify the change in
enrollment rate over time:

\deqn{
    \lambda = \left\{
      \begin{array}{ll}
        0.3 & \textrm{time} \in [0, 5) \\
        0.7 & \textrm{time} \in [5, 10) \\
        0.9 & \textrm{time} \in [10, 15) \\
        1.2 & \textrm{time} \in [15, \infty) \\
      \end{array}
    \right.
}

Then, to simulate individual patient enrollment dates with a sample size
(\code{N_total}) of 50, we use

\code{enrollment(lambda = c(0.3, 0.7, 0.9, 1.2), N_total = 50, lambda_time = c(0, 5, 10, 15))}
}
\examples{
enrollment(lambda = c(0.003, 0.7), N_total = 100, lambda_time = c(0, 10))
enrollment(lambda = c(0.3, 0.5, 0.9, 1.2, 2.1), N_total = 200,
           lambda_time = c(0, 20, 30, 40, 60))
}
\seealso{
This function is based on the \code{enrollment} function from the
\href{https://cran.r-project.org/package=bayesCT}{\code{bayesCT}}
R package.
}
