% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_continuous_conditional.R
\name{alpha.continuous.cond}
\alias{alpha.continuous.cond}
\title{variance effect conditioned on continuous variables}
\usage{
alpha.continuous.cond(qt, g, x, iter_num = 50, eps_param = 1e-10)
}
\arguments{
\item{qt}{A numeric vector.}

\item{g}{An integer vector.}

\item{x}{A numeric matrix, each column represents a covariate.}

\item{iter_num}{An integer. Represents the number of iterations performed in the Gauss-Newton algorithm}

\item{eps_param}{A number. The Gauss-Newton algorithm terminates if the incriment change of all variance estimates is smaller than this number.}
}
\value{
A list with the values:
* alpha, the estimated variance effect, conditioned on the covariates
* pval, the p-value corresponding to alpha
}
\description{
We estimate the variance effect of a variant conditioned on one or more continous variable
We apply a likelyhood ratio test with one degree of freedom

H0: All covariates have a variance effect, but not the variant
H1: The variant has a variance effect, and the covariates as well
}
\examples{
n_val <- 50000
x <- matrix(0,nrow = n_val, ncol = 4)
for(i in 1:4) {
x[, i] <- rnorm(n_val)
}
g_vec <- rbinom(n_val,2,0.3)
var_vec <- exp(0.2 * x[, 1] - 0.3 * x[, 4] + 0.3 * g_vec)
qt_vec <- rnorm(n_val, 0, sqrt(var_vec))
res <- alpha.continuous.cond(qt_vec, g_vec, x)
}
