(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39248,       1250]
NotebookOptionsPosition[     37471,       1187]
NotebookOutlinePosition[     37836,       1203]
CellTagsIndexPosition[     37793,       1200]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"AR", " ", "1", " ", "Decomposition"}], " ", "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.6349550490022197`*^9, 3.6349550603200183`*^9}, {
  3.634955234015973*^9, 3.634955238799157*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Define", " ", "haar", " ", "wv", " ", "for", " ", "AR", " ", "1"}],
   " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6349553269489555`*^9, 3.634955333199503*^9}, {
  3.6349561710977125`*^9, 3.634956175849888*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"\[Tau]", ",", 
     SubscriptBox["\[Rho]", "0"], ",", 
     SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["\[Tau]", "2"], "\[Minus]", 
         RowBox[{"3", 
          SubscriptBox["\[Rho]", "0"]}]}], "\[Minus]", 
        FractionBox[
         RowBox[{"\[Tau]", 
          SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"]}], "+", 
       RowBox[{
        RowBox[{"4", 
         SubsuperscriptBox["\[Rho]", "0", 
          RowBox[{
           FractionBox["\[Tau]", "2"], "+", "1"}]]}], "\[Minus]", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{"\[Tau]", "+", "1"}]]}]}], ")"}], 
     SubsuperscriptBox["\[Nu]", "0", "2"]}], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Tau]", "2"], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "\[Minus]", 
        SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{"1", "\[Minus]", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]], " "}], 
  TraditionalForm]], "Input",
 CellChangeTimes->{{3.634955111546692*^9, 3.6349551639946566`*^9}, {
  3.6349552408916745`*^9, 3.63495524589091*^9}, {3.634955317642658*^9, 
  3.634955325177517*^9}, {3.6349554309936867`*^9, 3.63495543157683*^9}, {
  3.6349556879982424`*^9, 3.6349557140526857`*^9}, {3.6349561165732284`*^9, 
  3.6349561182116337`*^9}, {3.6374124870377607`*^9, 3.637412498234825*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Check", " ", "entry"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.634956121354411*^9, 3.6349561268587728`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"f", "[", 
   RowBox[{"\[Tau]", ",", 
    SubscriptBox["\[Rho]", "0"], ",", 
    SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}], TraditionalForm]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["\[Tau]", "2"], "-", 
     RowBox[{"3", " ", 
      SubscriptBox["\[Rho]", "0"]}], "-", 
     FractionBox[
      RowBox[{"\[Tau]", " ", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
     RowBox[{"4", " ", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"1", "+", 
        FractionBox["\[Tau]", "2"]}]]}], "-", 
     SubsuperscriptBox["\[Rho]", "0", 
      RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.635130568114169*^9, 3.6374125069832125`*^9, 
  3.6433055290507135`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  FormBox[
   RowBox[{"f", "[", 
    RowBox[{"\[Tau]", ",", 
     SubscriptBox["\[Rho]", "0"], ",", 
     SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}],
   TraditionalForm], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Tau]"}], "+", 
     RowBox[{
      SubscriptBox["\[Rho]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"6", "+", 
        RowBox[{"\[Tau]", " ", 
         SubscriptBox["\[Rho]", "0"]}], "-", 
        RowBox[{"8", " ", 
         SubsuperscriptBox["\[Rho]", "0", 
          RowBox[{"\[Tau]", "/", "2"}]]}], "+", 
        RowBox[{"2", " ", 
         SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Rho]", "0"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.6374125228553357`*^9, 3.643305541079671*^9}]
}, Open  ]],

Cell[BoxData[
 FractionBox[
  RowBox[{" ", 
   RowBox[{
    SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[Tau]"}], "+", 
      RowBox[{
       SubscriptBox["\[Rho]", "0"], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", 
         RowBox[{"\[Tau]", " ", 
          SubscriptBox["\[Rho]", "0"]}], "-", 
         RowBox[{"8", " ", 
          SubsuperscriptBox["\[Rho]", "0", 
           RowBox[{"\[Tau]", "/", "2"}]]}], "+", 
         RowBox[{"2", " ", 
          SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}]}]}], 
     ")"}]}]}], 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Rho]", "0"]}], ")"}]}]]], "Input",
 CellChangeTimes->{{3.6374125105900326`*^9, 3.6374125289887133`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Take", " ", "derivative", " ", 
   RowBox[{"w", ".", "r", ".", "t"}], " ", 
   RowBox[{
    RowBox[{"v", "[", "0", "]"}], "^", "2"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.63495816612156*^9, 3.634958178357585*^9}, {
  3.6349583782290134`*^9, 3.6349583786291122`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  FormBox[
   FractionBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox["\[Tau]", "2"], "\[Minus]", 
        RowBox[{"3", 
         SubscriptBox["\[Rho]", "0"]}]}], "\[Minus]", 
       FractionBox[
        RowBox[{"\[Tau]", 
         SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"]}], "+", 
      RowBox[{
       RowBox[{"4", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{
          FractionBox["\[Tau]", "2"], "+", "1"}]]}], "\[Minus]", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"\[Tau]", "+", "1"}]]}]}], ")"}], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Tau]", "2"], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "\[Minus]", 
        SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{"1", "\[Minus]", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]],
   TraditionalForm]}]], "Input",
 CellChangeTimes->{{3.6349583826631107`*^9, 3.6349583892957497`*^9}, {
  3.6374125550857024`*^9, 3.6374125554463835`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["\[Tau]", "2"], "-", 
     RowBox[{"3", " ", 
      SubscriptBox["\[Rho]", "0"]}], "-", 
     FractionBox[
      RowBox[{"\[Tau]", " ", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
     RowBox[{"4", " ", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"1", "+", 
        FractionBox["\[Tau]", "2"]}]]}], "-", 
     SubsuperscriptBox["\[Rho]", "0", 
      RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.6349583917573586`*^9, 3.6374125589117985`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   FormBox[
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["\[Tau]", "2"], "\[Minus]", 
         RowBox[{"3", 
          SubscriptBox["\[Rho]", "0"]}]}], "\[Minus]", 
        FractionBox[
         RowBox[{"\[Tau]", 
          SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"]}], "+", 
       RowBox[{
        RowBox[{"4", 
         SubsuperscriptBox["\[Rho]", "0", 
          RowBox[{
           FractionBox["\[Tau]", "2"], "+", "1"}]]}], "\[Minus]", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{"\[Tau]", "+", "1"}]]}]}], ")"}], 
     RowBox[{
      FractionBox[
       SuperscriptBox["\[Tau]", "2"], "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "\[Minus]", 
         SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], 
      RowBox[{"(", 
       RowBox[{"1", "\[Minus]", 
        SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]],
    TraditionalForm], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.6349558002760096`*^9, 3.6349558143554907`*^9}, {
   3.634955948707717*^9, 3.634955949642948*^9}, {3.63495844372421*^9, 
   3.634958448440377*^9}, 3.6351362743500185`*^9, 3.6374125677035575`*^9, 
   3.6433062218800097`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "\[Tau]"}], "+", 
   RowBox[{
    SubscriptBox["\[Rho]", "0"], " ", 
    RowBox[{"(", 
     RowBox[{"6", "+", 
      RowBox[{"\[Tau]", " ", 
       SubscriptBox["\[Rho]", "0"]}], "-", 
      RowBox[{"8", " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"\[Tau]", "/", "2"}]]}], "+", 
      RowBox[{"2", " ", 
       SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Rho]", "0"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.6349584502658277`*^9, 3.6351362698979177`*^9, 
  3.637412599328952*^9, 3.643306226267089*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Take", " ", "first", " ", "derivative", " ", 
   RowBox[{"w", ".", "r", ".", "t"}], " ", 
   RowBox[{"p", "[", "0", "]"}]}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    FormBox[
     FormBox[
      RowBox[{"f", "[", 
       RowBox[{"\[Tau]", ",", 
        SubscriptBox["\[Rho]", "0"], ",", 
        SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}],
      TraditionalForm],
     TraditionalForm], ",", 
    SubscriptBox["\[Rho]", "0"]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.63495530379823*^9, 3.6349553069620132`*^9}, {
   3.634955453603277*^9, 3.634955465434203*^9}, {3.6349555601266203`*^9, 
   3.634955588806712*^9}, 3.634955670285862*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"\[Tau]", " ", 
       SubscriptBox["\[Rho]", "0"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox["\[Tau]", "2"]}], ")"}], " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"\[Tau]", "/", "2"}]]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Tau]"}], ")"}], " ", 
       SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
    SubscriptBox["\[Rho]", "0"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Tau]", "2"], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["\[Rho]", "0"]}], "-", 
      FractionBox[
       RowBox[{"\[Tau]", " ", 
        SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
      RowBox[{"4", " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"1", "+", 
         FractionBox["\[Tau]", "2"]}]]}], "-", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Tau]", "2"], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["\[Rho]", "0"]}], "-", 
      FractionBox[
       RowBox[{"\[Tau]", " ", 
        SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
      RowBox[{"4", " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"1", "+", 
         FractionBox["\[Tau]", "2"]}]]}], "-", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.6349553634069724`*^9, {3.634955406677673*^9, 3.634955418668638*^9}, {
   3.6349554555997705`*^9, 3.634955466839552*^9}, {3.6349555646007304`*^9, 
   3.6349556169836807`*^9}, {3.634955666519932*^9, 3.634955671000039*^9}, {
   3.634955701722637*^9, 3.63495572049728*^9}, 3.637412610441859*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     FormBox[
      FormBox[
       RowBox[{"f", "[", 
        RowBox[{"\[Tau]", ",", 
         SubscriptBox["\[Rho]", "0"], ",", 
         SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}],
       TraditionalForm],
      TraditionalForm], ",", 
     SubscriptBox["\[Rho]", "0"]}], "]"}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.634955347534046*^9, 3.6349553862866306`*^9}, {
  3.634955602047987*^9, 3.634955631352234*^9}, {3.6349557460536003`*^9, 
  3.634955788173016*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "2"]}]], 
  RowBox[{"2", " ", 
   SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "\[Tau]", "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"\[Tau]", "/", "2"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "6"}], "+", "\[Tau]"}], ")"}], " ", 
            SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Rho]", "0", "\[Tau]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", "\[Tau]"}], ")"}], " ", 
            SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      SubscriptBox["\[Rho]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"6", "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", "\[Tau]", "+", 
           RowBox[{"\[Tau]", " ", 
            SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.6349557294244876`*^9, 3.6349557500505886`*^9}, 
   3.63495579138381*^9, 3.6374126129524717`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Take", " ", "second", " ", "Derivative", " ", 
   RowBox[{"w", ".", "r", ".", "t"}], " ", 
   RowBox[{"p", "[", "0", "]"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6349558750765066`*^9, 3.6349558768999586`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    FormBox[
     FormBox[
      RowBox[{"f", "[", 
       RowBox[{"\[Tau]", ",", 
        SubscriptBox["\[Rho]", "0"], ",", 
        SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}],
      TraditionalForm],
     TraditionalForm], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Rho]", "0"], ",", "2"}], "}"}]}], "]"}], " "}]], "Input",\

 CellChangeTimes->{{3.634955901590064*^9, 3.6349559051419425`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox["\[Tau]", "2"]], 
  RowBox[{"2", " ", 
   SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "\[Tau]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["\[Tau]", "2"]}], ")"}], " ", "\[Tau]", " ", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["\[Tau]", "2"]}]]}], "-", 
       RowBox[{"\[Tau]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Tau]"}], ")"}], " ", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Tau]"}]]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"\[Tau]", " ", 
         SubscriptBox["\[Rho]", "0"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["\[Tau]", "2"]}], ")"}], " ", 
         SubsuperscriptBox["\[Rho]", "0", 
          RowBox[{"\[Tau]", "/", "2"}]]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Tau]"}], ")"}], " ", 
         SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          SubscriptBox["\[Rho]", "0"]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "2"]}]], "+", 
        FractionBox["2", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["\[Tau]", "2"], "-", 
        RowBox[{"3", " ", 
         SubscriptBox["\[Rho]", "0"]}], "-", 
        FractionBox[
         RowBox[{"\[Tau]", " ", 
          SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
        RowBox[{"4", " ", 
         SubsuperscriptBox["\[Rho]", "0", 
          RowBox[{"1", "+", 
           FractionBox["\[Tau]", "2"]}]]}], "-", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{"1", "+", "\[Tau]"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"8", " ", 
          SubscriptBox["\[Rho]", "0"]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "2"]}]], "+", 
        FractionBox["6", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SubscriptBox["\[Rho]", "0"]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          FractionBox[
           RowBox[{"8", " ", 
            SubsuperscriptBox["\[Rho]", "0", "2"]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "3"]], "+", 
          FractionBox["2", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "2"]]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SubscriptBox["\[Rho]", "0"]}], ")"}], "2"]]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.6349559059261365`*^9, 3.637412616098361*^9, 
  3.637413600835126*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    FormBox[
     FormBox[
      RowBox[{"f", "[", 
       RowBox[{"\[Tau]", ",", 
        SubscriptBox["\[Rho]", "0"], ",", 
        SubsuperscriptBox["\[Nu]", "0", "2"]}], "]"}],
      TraditionalForm],
     TraditionalForm], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Rho]", "0"], ",", "2"}], "}"}]}], "]"}], " ", 
  "]"}]], "Input",
 CellChangeTimes->{{3.6349559160276346`*^9, 3.634955922724291*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "5"], " ", 
    SubscriptBox["\[Rho]", "0"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "3"]}]], 
  RowBox[{"2", " ", 
   SubsuperscriptBox["\[Nu]", "0", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      SubscriptBox["\[Rho]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"4", "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", "\[Tau]"}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "0"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"6", "+", "\[Tau]"}], ")"}], " ", 
               SubscriptBox["\[Rho]", "0"]}], "+", 
              RowBox[{"\[Tau]", " ", 
               SubsuperscriptBox["\[Rho]", "0", "2"]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"\[Tau]", "/", "2"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Tau]", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Tau]"}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Tau]"}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "0"], " ", 
            RowBox[{"(", 
             RowBox[{"64", "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "6"}], "+", "\[Tau]"}], ")"}], " ", "\[Tau]"}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "8"}], "+", "\[Tau]"}], ")"}], " ", 
               SubscriptBox["\[Rho]", "0"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "8"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "6"}], "+", "\[Tau]"}], ")"}], " ", 
                  SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Rho]", "0", "\[Tau]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Tau]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Tau]"}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Tau]"}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "0"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", "\[Tau]"}], ")"}], " ", "\[Tau]"}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "\[Tau]"}], ")"}], " ", 
               SubscriptBox["\[Rho]", "0"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", "\[Tau]"}], ")"}], " ", 
                  SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.634955923936591*^9, 3.637412631959309*^9, 
  3.6374136043408065`*^9, 3.643314549929809*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Derivative", " ", 
    RowBox[{"w", ".", "r", ".", "t"}], " ", 
    SubsuperscriptBox["\[Nu]", "0", "2"], " ", "and", " ", 
    SubscriptBox["\[Rho]", "0"]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FormBox[
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["\[Tau]", "2"], "\[Minus]", 
           RowBox[{"3", 
            SubscriptBox["\[Rho]", "0"]}]}], "\[Minus]", 
          FractionBox[
           RowBox[{"\[Tau]", 
            SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"]}], "+", 
         RowBox[{
          RowBox[{"4", 
           SubsuperscriptBox["\[Rho]", "0", 
            RowBox[{
             FractionBox["\[Tau]", "2"], "+", "1"}]]}], "\[Minus]", 
          SubsuperscriptBox["\[Rho]", "0", 
           RowBox[{"\[Tau]", "+", "1"}]]}]}], ")"}], 
       RowBox[{
        FractionBox[
         SuperscriptBox["\[Tau]", "2"], "2"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "\[Minus]", 
           SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], 
        RowBox[{"(", 
         RowBox[{"1", "\[Minus]", 
          SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]],
      TraditionalForm], ",", 
     RowBox[{"{", 
      SubscriptBox["\[Rho]", "0"], "}"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.643332859255574*^9, 3.6433329058670335`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"\[Tau]", " ", 
        SubscriptBox["\[Rho]", "0"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["\[Tau]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{"\[Tau]", "/", "2"}]]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Tau]"}], ")"}], " ", 
        SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["\[Tau]", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SubscriptBox["\[Rho]", "0"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["\[Tau]", "2"], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["\[Rho]", "0"]}], "-", 
       FractionBox[
        RowBox[{"\[Tau]", " ", 
         SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
       RowBox[{"4", " ", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{"1", "+", 
          FractionBox["\[Tau]", "2"]}]]}], "-", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["\[Tau]", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["\[Tau]", "2"], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["\[Rho]", "0"]}], "-", 
       FractionBox[
        RowBox[{"\[Tau]", " ", 
         SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
       RowBox[{"4", " ", 
        SubsuperscriptBox["\[Rho]", "0", 
         RowBox[{"1", "+", 
          FractionBox["\[Tau]", "2"]}]]}], "-", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["\[Tau]", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.643332913760971*^9, 3.6433329269692187`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"\[Tau]", " ", 
       SubscriptBox["\[Rho]", "0"]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox["\[Tau]", "2"]}], ")"}], " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"\[Tau]", "/", "2"}]]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Tau]"}], ")"}], " ", 
       SubsuperscriptBox["\[Rho]", "0", "\[Tau]"]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SubscriptBox["\[Rho]", "0"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Tau]", "2"], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["\[Rho]", "0"]}], "-", 
      FractionBox[
       RowBox[{"\[Tau]", " ", 
        SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
      RowBox[{"4", " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"1", "+", 
         FractionBox["\[Tau]", "2"]}]]}], "-", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Tau]", "2"], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["\[Rho]", "0"]}], "-", 
      FractionBox[
       RowBox[{"\[Tau]", " ", 
        SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"], "+", 
      RowBox[{"4", " ", 
       SubsuperscriptBox["\[Rho]", "0", 
        RowBox[{"1", "+", 
         FractionBox["\[Tau]", "2"]}]]}], "-", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"1", "+", "\[Tau]"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "3"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.6433329213578386`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    FormBox[
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["\[Tau]", "2"], "\[Minus]", 
          RowBox[{"3", 
           SubscriptBox["\[Rho]", "0"]}]}], "\[Minus]", 
         FractionBox[
          RowBox[{"\[Tau]", 
           SubsuperscriptBox["\[Rho]", "0", "2"]}], "2"]}], "+", 
        RowBox[{
         RowBox[{"4", 
          SubsuperscriptBox["\[Rho]", "0", 
           RowBox[{
            FractionBox["\[Tau]", "2"], "+", "1"}]]}], "\[Minus]", 
         SubsuperscriptBox["\[Rho]", "0", 
          RowBox[{"\[Tau]", "+", "1"}]]}]}], ")"}], 
      RowBox[{
       FractionBox[
        SuperscriptBox["\[Tau]", "2"], "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "\[Minus]", 
          SubscriptBox["\[Rho]", "0"]}], ")"}], "2"], 
       RowBox[{"(", 
        RowBox[{"1", "\[Minus]", 
         SubsuperscriptBox["\[Rho]", "0", "2"]}], ")"}]}]],
     TraditionalForm], ",", 
    RowBox[{"{", 
     SubscriptBox["\[Rho]", "0"], "}"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SubscriptBox["\[Rho]", "0"]}], ")"}], "2"]}]], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "\[Tau]", "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["\[Rho]", "0", 
       RowBox[{"\[Tau]", "/", "2"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "6"}], "+", "\[Tau]"}], ")"}], " ", 
            SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Rho]", "0", "\[Tau]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", "\[Tau]"}], ")"}], " ", 
            SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      SubscriptBox["\[Rho]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"6", "-", "\[Tau]", "+", 
        RowBox[{
         SubscriptBox["\[Rho]", "0"], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", "\[Tau]", "+", 
           RowBox[{"\[Tau]", " ", 
            SubscriptBox["\[Rho]", "0"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.64333292139485*^9, 3.643332932675621*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Random", " ", "Walk"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    FormBox[
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"\[Tau]", ",", 
        SuperscriptBox["\[Sigma]", "2"]}], "]"}], ":="}],
     TraditionalForm], 
    FormBox[
     TagBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Sigma]", "2"], "(", 
        RowBox[{
         RowBox[{"2", 
          SuperscriptBox["\[Tau]", "2"]}], "+", "4"}], ")"}], 
       RowBox[{"24", "\[Tau]"}]],
      "MathMLPresentationTag",
      AutoDelete->True],
     TraditionalForm]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.63741371576912*^9, 3.637413753312436*^9}},
 EmphasizeSyntaxErrors->True]
},
WindowSize->{1656, 960},
WindowMargins->{{-1814, Automatic}, {122, Automatic}},
Magnification->2.,
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (July 1, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 266, 6, 99, "Input"],
Cell[827, 28, 258, 5, 60, "Input"],
Cell[1088, 35, 1546, 42, 161, "Input"],
Cell[2637, 79, 160, 3, 60, "Input"],
Cell[CellGroupData[{
Cell[2822, 86, 189, 5, 65, "Input"],
Cell[3014, 93, 932, 28, 120, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3983, 126, 235, 7, 66, "Input"],
Cell[4221, 135, 907, 28, 91, "Output"]
}, Open  ]],
Cell[5143, 166, 950, 30, 108, "Input"],
Cell[6096, 198, 322, 7, 60, "Input"],
Cell[CellGroupData[{
Cell[6443, 209, 1094, 33, 200, "Input"],
Cell[7540, 244, 860, 26, 120, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8437, 275, 1285, 36, 201, "Input"],
Cell[9725, 313, 846, 26, 91, "Output"]
}, Open  ]],
Cell[10586, 342, 193, 4, 60, "Input"],
Cell[CellGroupData[{
Cell[10804, 350, 540, 15, 66, "Input"],
Cell[11347, 367, 2975, 87, 209, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14359, 459, 567, 16, 66, "Input"],
Cell[14929, 477, 2029, 62, 131, "Output"]
}, Open  ]],
Cell[16973, 542, 264, 5, 60, "Input"],
Cell[CellGroupData[{
Cell[17262, 551, 472, 16, 66, "Input"],
Cell[17737, 569, 4394, 130, 350, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22168, 704, 499, 16, 66, "Input"],
Cell[22670, 722, 4103, 119, 168, "Output"]
}, Open  ]],
Cell[26788, 844, 1482, 43, 249, "Input"],
Cell[CellGroupData[{
Cell[28295, 891, 2722, 82, 365, InheritFromParent],
Cell[31020, 975, 2559, 80, 209, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33616, 1060, 1141, 35, 152, "Input"],
Cell[34760, 1097, 1928, 60, 189, "Output"]
}, Open  ]],
Cell[36703, 1160, 764, 25, 184, "Input"]
}
]
*)

(* End of internal cache information *)
