% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootAUC.R
\name{bootAUCdiff}
\alias{bootAUCdiff}
\title{Compute difference in AUC between two joint models by bootstrapping.}
\usage{
bootAUCdiff(
  fits,
  data,
  Tstart,
  delta,
  boot.size = NULL,
  nboot = 100,
  replace = TRUE,
  ci = 0.95,
  nsim = 0,
  progress = TRUE,
  control = list()
)
}
\arguments{
\item{fits}{a list of length two, each element containing a joint model 
fit by the \code{joint} function. The second element in \code{fits} should be the more complex.
Both elements of \code{fits} should be fit to the \strong{same} \code{data}.}

\item{data}{the data to which both of the \code{joint} models was fit.}

\item{Tstart}{The start of the time window of interest, \code{Tstart} denotes the time
point up to which longitudinal process(es) is used in calculation of survival probabilities.}

\item{delta}{scalar denoting the length of time interval to check for failure times.}

\item{boot.size}{the number of samples to take from the data. Default value is \code{NULL}
which uses the number of distinct \code{ids} in the \code{data}.}

\item{nboot}{the number of bootstrap replicates upon which the summaries are formed.}

\item{replace}{logical, can \code{id}s be randomly sampled more than once? Defaults to
\code{replace = TRUE}.}

\item{ci}{confidence interval to be returned on AUC estimates, defaults to 
\code{ci = 0.95} which produces a 95\% confidence interval.}

\item{nsim}{number of simulations to use in each call to \code{\link{dynPred}},
defaults to \code{nsim=0} which results in first-order estimates being used.}

\item{progress}{logical, should a progress bar showing the percentage of completed
bootstrapped estimates? Defauts to \code{progress=TRUE}.}

\item{control}{list of control arguments to pass to \code{\link{dynPred}} via 
\code{\link{ROC}}, these largely control the MC simulation scheme. Note the user
shouldn't specify the number of  simulations here as well, as this is covered 
by the argument \code{nsim}.}
}
\value{
a list of class \code{bootAUC.diff.joint} containing relevant summary information,
items of interest from each call to \code{\link{ROC}} and bootstrapping settings.
}
\description{
Compute summary for difference in area under the curve of two
competing joint model fits, given a set of data and a time-window of interest by bootstrapping.
}
\examples{
\donttest{
# Compare linear vs quadratic fit to log(serBilir) in PBC data ---------
data(PBC)
PBC$serBilir <- log(PBC$serBilir)
long.formulas1 <- list(serBilir ~ drug * time + (1 + time|id))
long.formulas2 <- list(serBilir ~ drug * (time + I(time^2)) + (1 + time + I(time^2)|id))
surv.formula <- Surv(survtime, status) ~ drug
family <- list('gaussian')
# Fit two separate models ----------------------------------------------
fit1 <- joint(long.formulas1, surv.formula, PBC, family)
fit2 <- joint(long.formulas2, surv.formula, PBC, family)
# Cast to list, where more saturated/complex is second entry.
fits <- list(fit1, fit2)
# 50 (x2) first order estimates in window (8, 9] ---------------------------
AUC.diffs <- bootAUCdiff(fits, PBC, Tstart = 8, delta = 1, nboot = 50)
# print
AUC.diffs
}
}
\seealso{
\code{\link{bootAUC}}, \code{\link{dynPred}} and \code{\link{ROC}}.
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
