% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_arcs.R
\name{add_arcs}
\alias{add_arcs}
\title{Add arcs to a Gaussian mixture graphical model}
\usage{
add_arcs(gmgm, arcs)
}
\arguments{
\item{gmgm}{An object of class \code{gmbn} or \code{gmdbn}.}

\item{arcs}{A data frame containing the added arcs. The column \code{from}
describes the start node, the column \code{to} the end node and the column
\code{lag} the time lag between them. Missing values in \code{from} or
\code{to} are interpreted as "all possible nodes", which allows to quickly
define large set of arcs that share common attributes. Missing values in
\code{lag} are replaced by 0. If \code{gmgm} is a \code{gmdbn} object, the
same arcs are added to each of its \code{gmbn} elements. This constraint can
be overcome by passing a list of data frames named after some of these
elements (\code{b_1}, \dots) and containing arcs specifically added to them.
The arcs whose time lags exceed the maximum temporal depth of their
\code{gmbn} element are not taken into account.}
}
\value{
The \code{gmbn} or \code{gmdbn} object after adding the arcs.
}
\description{
This function adds arcs to a Gaussian mixture graphical model. For each added
arc, a variable related to the start node is added to the Gaussian mixture
model describing the local distribution over the end node and its parents,
with mean 0 and variance 1 for each mixture component.
}
\examples{
data(gmbn_body)
gmbn_1 <- add_arcs(gmbn_body,
                   data.frame(from = c("GENDER", "AGE"),
                              to = c("GLYCO", "WEIGHT")))

data(gmdbn_air)
gmdbn_1 <- add_arcs(gmdbn_air,
                    list(b_2 = data.frame(from = "WIND", to = "NO2", lag = 1),
                         b_13 = data.frame(from = c("NO2", "NO2"),
                                           to = c("O3", "O3"), lag = c(0, 1))))

}
\seealso{
\code{\link{add_nodes}}, \code{\link{remove_arcs}},
\code{\link{remove_nodes}}, \code{\link{rename_nodes}}
}
