% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{DataFrameStack}
\alias{DataFrameStack}
\alias{as.DataFrameStack}
\alias{DataFrameStack.data.frame}
\alias{as.DataFrameStack.data.frame}
\alias{DataFrameStack.array}
\alias{as.DataFrameStack.array}
\alias{DataFrameStack.list}
\alias{as.DataFrameStack.list}
\title{Create a data frame stack}
\usage{
DataFrameStack(x, ...)

as.DataFrameStack(x, ...)

\method{DataFrameStack}{data.frame}(x, stackDim = 2, dim = NULL, Dimnames = NULL, ...)

\method{as.DataFrameStack}{data.frame}(x, stackDim = 2, dim = NULL, Dimnames = NULL, ...)

\method{DataFrameStack}{array}(x, stackDim = 2, ...)

\method{as.DataFrameStack}{array}(x, stackDim = 2, ...)

\method{DataFrameStack}{list}(x, stackDimName = NULL, Dimnames = NULL, ...)

\method{as.DataFrameStack}{list}(x, stackDimName = NULL, Dimnames = NULL, ...)
}
\arguments{
\item{x}{object containing the individual data sets, this can be an arra, a list or a data.frame}

\item{...}{further parameters, ignored but necessary for generic functionality}

\item{stackDim}{for "array" and "data.frame" input, which dimension
(name or index) identifies the stacking dimension;
this is typically the replication, realisation or time slice index}

\item{dim}{for "data.frame" input,  how is the data provided to be arranged in slices?}

\item{Dimnames}{for "list" and "data.frame input, which names do you want to give
to the resulting array-like structure; note that for input "array" it is necessary
that these names are already given to the input array beforehand!}

\item{stackDimName}{for "list" input, which name or index do you want to
give to the stacking dimension?}
}
\value{
The data provided reorganised as a DataFrameStack, with several additional attributes.
}
\description{
Make a stacked data frame, that is, a stack of data.frames representing e.g. repeated measurements,
parallel time series, or a stack of multivariate realisation of some random process. If a data frame
is analogous to a matrix, a DataFrameStack is analogous to an array. It is highly recommendable to work
with named dimensions in stacked data frames.
}
\section{Functions}{
\itemize{
\item \code{DataFrameStack}: create a DataFrameStack from an array

\item \code{as.DataFrameStack}: create a DataFrameStack from an array

\item \code{as.DataFrameStack.data.frame}: create a DataFrameStack from an array

\item \code{DataFrameStack.array}: create a DataFrameStack from an array

\item \code{as.DataFrameStack.array}: create a DataFrameStack from an array

\item \code{DataFrameStack.list}: create a DataFrameStack from a list

\item \code{as.DataFrameStack.list}: create a DataFrameStack from an array
}}

\examples{
ll = lapply(1:3, function(i) as.data.frame(matrix(1:10+(i-1)*10, ncol=2)))
dfs = DataFrameStack(ll, stackDimName="rep")
dimnames(dfs)
df = as.data.frame(matrix(1:30, ncol=6))
dfs = DataFrameStack(df, dimnames = list(obs=1:5, vars=c("A","B"), rep=1:3), stackDim = "rep")
dimnames(dfs)
ar = array(1:30, dim = c(5,2,3), dimnames=list(obs=1:5, vars=c("A","B"), rep=1:3))
dfs = DataFrameStack(ar, stackDim="rep")
dimnames(dfs)
}
\seealso{
\code{\link[=stackDim]{stackDim()}} to get or set the stacking dimension;
\code{\link[=noStackDim]{noStackDim()}} to get (not set) the non-stacking dimension;
\code{\link[=as.array.DataFrameStack]{as.array.DataFrameStack()}} and \code{\link[=as.list.DataFrameStack]{as.list.DataFrameStack()}} to
convert the stack to an array or a list;
\code{\link[=dimnames.DataFrameStack]{dimnames.DataFrameStack()}} to get the dimension names;
[\verb{[.DataFrameStack}] to extract rows of a stack;
\code{\link[=getStackElement]{getStackElement()}} and \code{setStackElement} (same page as \code{getStackElement})
to extract/modify an
element of the stack; \code{\link[=gmApply]{gmApply()}} to
apply any function to the stack, typically element-wise;
and \code{\link[=swarmPlot]{swarmPlot()}} to combine plot elements for each stack element
into a single plot.
}
