% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{image_cokriged}
\alias{image_cokriged}
\alias{image_cokriged.default}
\alias{image_cokriged.spatialGridRmult}
\alias{image_cokriged.spatialGridAcomp}
\title{Plot an image of gridded data}
\usage{
image_cokriged(x, ...)

\method{image_cokriged}{default}(
  x,
  ivar = 3,
  breaks = quantile(as.data.frame(x)[, ivar], probs = c(0:10)/10, na.rm = TRUE),
  col = spectralcolors(length(breaks) - 1),
  legendPropSpace = 0.2,
  legendPos = "top",
  main = ifelse(is.character(ivar), ivar, colnames(x)[ivar]),
  ...
)

\method{image_cokriged}{spatialGridRmult}(
  x,
  ivar = 1,
  isim = NULL,
  breaks = 10,
  mask = attr(x, "mask"),
  col = spectralcolors(length(breaks) - 1),
  legendPropSpace = 0.2,
  legendPos = "top",
  main = ifelse(is.character(ivar), ivar, dimnames(x)[[length(dimnames(x))]][ivar]),
  ...
)

\method{image_cokriged}{spatialGridAcomp}(
  x,
  ivar = 1,
  isim = NULL,
  breaks = 10,
  mask = attr(x, "mask"),
  col = spectralcolors(length(breaks) - 1),
  legendPropSpace = 0.2,
  legendPos = "top",
  main = ifelse(is.character(ivar), ivar, dimnames(x)[[length(dimnames(x))]][ivar]),
  ...
)
}
\arguments{
\item{x}{object with the interpolated / simulated data; currently there are methods
for "spatialGridAcomp" and "spatialGridRmult", but the default method is able to
deal with "SpatialPointsDataFrame", "SpatialPixelsDataFrame" and "SpatialGridDataFrame"
objects, and with the "data.frame" output of \code{\link[gstat:predict.gstat]{gstat::predict.gstat()}} and
\link{predict_gmSpatialModel}}

\item{...}{generic functionality, currently ignored}

\item{ivar}{which variable do you want to plot?}

\item{breaks}{either the approximate number of breaks, or the vector of
exact breaks to use for the plotting regions of the chosen variable}

\item{col}{vector of colors to use for the image}

\item{legendPropSpace}{which proportion of surface of the device should be used
for the legend? trial and error might be necessary to adjust this to your needs}

\item{legendPos}{where do you want your legend? one of c("top","left","right","bottom")}

\item{main}{main title for the plot}

\item{isim}{in case of simulated output, which simulation?}

\item{mask}{optional mask object if \code{x} is of class "spatialGridAcomp" or
"spatialGridRmult", and they have been masked  (see \code{\link[=setMask]{setMask()}})}
}
\value{
Invisibly, a list with elements \code{breaks} and \code{col} containing the breaks
and hexadecimal colors finally used for the z-values of the image. Particularly
useful for plotting other plotting elements on the same color scale.
}
\description{
Plot an image of one variable (possibly, one realisation) of output
of cokriging or cosimulation functions.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Plot an image of gridded data

\item \code{spatialGridRmult}: method for spatialGridRmult objects

\item \code{spatialGridAcomp}: method for spatialGridAcomp objects
}}

\examples{
\dontrun{
getTellus(cleanup=TRUE, TI=TRUE)
load("Tellus_TI.RData")
head(Tellus_TI)
coords = as.matrix(Tellus_TI[,1:2])
compo = compositions::acomp(Tellus_TI[,3:7])
dt = spatialGridAcomp(coords=coords, compo=compo)
image_cokriged(dt, ivar="MgO") # equi-spaced
image_cokriged(dt, ivar="MgO", breaks = NULL) # equi-probable
}
}
