% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottoget.R
\name{glottoget}
\alias{glottoget}
\title{Get glottodata from local path or online global databases}
\usage{
glottoget(
  glottodata = NULL,
  meta = FALSE,
  download = FALSE,
  dirpath = NULL,
  url = NULL
)
}
\arguments{
\item{glottodata}{options are:
\itemize{
\item A filepath to locally stored glottodata or glottosubdata with file extension (.xlsx .xls .gpkg
.shp). See also: options meta and simplify.
\item "glottobase" - Default option, an spatially enhanced version of \href{https://glottolog.org/}{glottolog}. See
\link{glottobooster} for details. If glottodata = NULL, "glottobase" will be loaded.
\item "wals" - This is a spatially enhanced version of \href{https://wals.info/}{WALS}.
\item "dplace" - Not yet supported. This is a spatially enhanced version of \href{https://d-place.org/}{D-PLACE}.
\item "glottolog" - This is a restructured (non-spatial) version of \href{https://glottolog.org/}{glottolog}.
\item "glottospace" - A simple dataset with glottocodes and a geometry column. This
is a subset of all languages in \href{https://glottolog.org/}{glottolog} with
spatial coordinates.
\item "demodata" - Built-in artificial glottodata (included for demonstration and testing).
\item "demosubdata" - Built-in artificial glottosubdata (included for demonstration and testing)
}}

\item{meta}{In case 'glottodata' is demodata/demosubdata: by default, meta sheets are not loaded. Use meta=TRUE if you want to include them.}

\item{download}{By default internally stored versions of global databases are used. Specify download = TRUE in case you want to download the latest version from a remote server.}

\item{dirpath}{Optional, if you want to store a global CLDF dataset in a specific directory, or load it from a specific directory.}

\item{url}{Zenodo url, something like this: "https://zenodo.org/api/records/3260727"}
}
\value{
A glottodata or glottosubdata object (a data.frame or list, depending on which glottodata is requested)
}
\description{
Load locally stored glottodata, download databases from online sources, or load built-in demo data
}
\examples{
\donttest{
glottoget("glottolog")
}
}
\seealso{
Other <glottodata>: 
\code{\link{glottosave}()}
}
\concept{<glottodata>}
