% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_presence_absence.R
\name{clean_coordinates}
\alias{clean_coordinates}
\title{Clean Coordinates of Presence/Absence Data}
\usage{
clean_coordinates(
  df,
  study_area,
  overlapping = FALSE,
  thinning_method = NULL,
  thinning_value = NULL,
  coords = c("decimalLongitude", "decimalLatitude"),
  by_timestamp = TRUE,
  seed = NULL
)
}
\arguments{
\item{df}{A dataframe object with rows representing points. Coordinates are in WGS84 (EPSG:4326) coordinate system.}

\item{study_area}{A spatial polygon in WGS84 (EPSG:4326) representing the boundaries within which coordinates should be kept.}

\item{overlapping}{Logical indicating whether points overlapping the polygon should be removed (TRUE) or kept (FALSE).}

\item{thinning_method}{Character; spatial thinning method to apply to occurrence data. Options are `c("None", "Distance", "Grid", "Precision")`. See `GeoThinneR` package for details.}

\item{thinning_value}{Numeric; value used for thinning depending on the selected method: distance in meters (`Distance`), grid resolution in degrees (`Grid`), or decimal precision (`Precision`).}

\item{coords}{Character vector specifying the column names for longitude and latitude.}

\item{by_timestamp}{If TRUE, clean coordinates taking into account different time periods defined in the column `timestamp`.}

\item{seed}{Optional; an integer seed for reproducibility of results.}
}
\value{
A cleaned data frame containing presence/absence data with valid coordinates.
}
\description{
This function cleans coordinates of presence/absence data by removing NA coordinates, rounding coordinates if specified, removing duplicated points, and removing points outside specified spatial polygon boundaries.
}
\details{
This function takes a data frame containing presence/absence data with longitude and latitude coordinates, a spatial polygon representing boundaries within which to keep points, and parameters for rounding coordinates and handling duplicated points. It returns a cleaned data frame with valid coordinates within the specified boundaries.
}
