% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ossification}
\alias{ossification}
\title{Teratogenic effects of phenytoin and trichloropropene oxide}
\format{
A data frame with 81 rows and 4 variables:
\describe{
  \item{fetuses}{a numeric vector giving the number of fetuses showing ossification on the left middle third phalanx.}
  \item{litter}{a numeric vector giving the litter size.}
  \item{pht}{a factor giving the dose (mg/kg) of phenytoin: "0 mg/kg" or "60 mg/kg".}
  \item{tcpo}{a factor giving the dose (mg/kg) of trichloropropene oxide: "0 mg/kg" or "100 mg/kg".}
}
}
\usage{
data(ossification)
}
\description{
The data come from a 2x2 factorial design with 81 pregnant mice. In the experiment each
pregnant mouse was randomly allocated to an control group and three treated groups, which
received daily, by gastric gavages, 60 mg/kg of phenytoin, 100 mg/kg of
trichloropropene oxide, or 60 mg/kg phenytoin and 100 mg/kg of trichloropropene
oxide. On day 18 of gestation, fetuses were recovered, stained, and cleared. Then, by
visual inspection, the presence or absence of ossification was determined for the different
joints of the right and left forepaws. The purpose of the experiment was to investigate the
synergy of phenytoin  and trichloropropene oxide to produce ossification at the phalanges,
that is, teratogenic effects. See Morel and Nagaraj (2012, page 103).
}
\examples{
data(ossification)
dev.new()
boxplot(100*fetuses/litter ~ pht, data=subset(ossification,tcpo=="0 mg/kg"),
        at=c(1:2) - 0.2, col="yellow", boxwex=0.25, xaxt="n",
        xlab="Dose of PHT", ylab="\% of fetuses showing ossification")
boxplot(100*fetuses/litter ~ pht, data=subset(ossification,tcpo=="100 mg/kg"),
        add=TRUE, at=c(1:2) + 0.2, col="blue", boxwex=0.25, xaxt="n")
axis(1, at=c(1:2), labels=levels(ossification$pht))
legend("bottomleft", legend=c("0 mg/kg","100 mg/kg"), fill=c("yellow","blue"),
       title="Dose of TCPO", bty="n", cex=0.9)
}
\references{
Morel J.G., Neerchal N.K. (1997) Clustered binary logistic regression in teratology data
using a finite mixture distribution. \emph{Statistics in Medicine} 16:2843-2853.

Morel J.G., Nagaraj N.K. (2012) \emph{Overdispersion Models in SAS}. SAS Institute Inc., Cary, North Carolina, USA.
}
\keyword{datasets}
