% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{liver}
\alias{liver}
\title{Liver cancer in mice}
\format{
A data frame with 8 rows and 3 variables:
\describe{
  \item{dose}{a numeric vector giving the dose, in parts per \eqn{10^4}, of 2-AAF.}
  \item{exposed}{a numeric vector giving the number of mice exposed to each dose of 2-AAF.}
  \item{cancer}{a numeric vector giving the number of mice with liver cancer for each dose of 2-AAF.}
}
}
\usage{
data(liver)
}
\description{
Female mice were continuously fed dietary concentrations of
2-Acetylaminofluorene (2-AAF), a carcinogenic and mutagenic derivative of fluorene.
Serially sacrificed, dead or moribund mice were examined for tumors and dates
of deaths were recorded. These data consist of the incidences of liver
neoplasms in the mice observed during 18 months.
}
\examples{
data(liver)
barplot(100*cancer/exposed ~ dose, beside=TRUE, data=liver, col="red",
        xlab="Dose of 2-AAF", ylab="\% of mice with liver cancer")
}
\references{
Zhang H., Zelterman D. (1999) Binary Regression for Risks in Excess of Subject-Specific Thresholds. \emph{Biometrics} 55:1247-1251.
}
\seealso{
\link{bladder}
}
\keyword{datasets}
