% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{overglm}
\alias{overglm}
\title{Negative Binomial and Beta-Binomial Regression Models}
\usage{
overglm(formula, family, weights, data, subset, start = NULL, ...)
}
\arguments{
\item{formula}{a \code{formula} expression of the form \code{response ~ predictors}, which is a symbolic description of the linear predictor of the model to be fitted to the data.}

\item{family}{a character string which describe the distribution of the response variable and the link function. The following distributions are supported: negative binomial I ("nb1"), negative binomial II ("nb2"), negative binomial III ("nb3"), and beta-binomial ("bb"). Link functions available for negative binomial and beta-binomial regression models are the same than those available for Poisson and binomial regression models, respectively. See \link{family} documentation.}

\item{weights}{an (optional) vector of positive "prior weights" to be used in the fitting process. The length of \code{weights} should be the same as the number of observations.}

\item{data}{an (optional) \code{data frame} in which to look for variables involved in the \code{formula} expression, as well as the variable specified in the argument \code{weights}.}

\item{subset}{an (optional) vector specifying a subset of observations to be used in the fitting process.}

\item{start}{an (optional) vector of starting values for the parameters in the linear predictor.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of the class overglm in which are stored the main results of the model fitted to the data. Some of those results can be easily accessed using functions as, for example, \code{print()}, \code{summary()}, \code{model.matrix()}, \code{estequa()}, \code{coef()}, \code{vcov()}, \code{logLik()}, \code{fitted()}, \code{confint()} and \code{predict()}. In addition, the model fitted to the data
can be assessed using functions as, for instance, \link{anova.overglm}, \link{residuals.overglm}, \link{dfbeta.overglm}, \link{cooks.distance.overglm} and \link{envelope.overglm}. The variable selection may be accomplished using \link{stepCriterion.overglm}.
}
\description{
Produces an object of the class overglm in which are stored the main results of the negative binomial or beta-binomial regression model fitted to the data.
}
\details{
The negative binomial distributions can be obtained as mixture of the Poisson and Gamma distributions. Let \eqn{Y | \lambda} ~ Poisson\eqn{(\lambda)}, where
E\eqn{(Y | \lambda)=\lambda} and Var\eqn{(Y | \lambda)=\lambda}, and
\eqn{\lambda} ~ Gamma\eqn{(\beta,\alpha)}, where E\eqn{(\lambda)=\beta} and Var\eqn{(\lambda)=\alpha\beta^2}. Therefore,

(1) If \eqn{\beta=\mu} and \eqn{\alpha=\phi} then \eqn{Y} ~ Binomial Negativa I\eqn{(\mu,\phi)},
E\eqn{(Y)=\mu} and Var\eqn{(Y)=\mu + \phi\mu^2}.

(2) If \eqn{\beta=\mu} and \eqn{\alpha=\phi/\mu} then \eqn{Y} ~ Binomial Negativa II\eqn{(\mu,\phi)},
E\eqn{(Y)=\mu} and Var\eqn{(Y)=(\phi + 1)\mu}.

(3) If \eqn{\beta=\mu} and \eqn{\alpha=\phi\mu} then \eqn{Y} ~ Binomial Negativa III\eqn{(\mu,\phi)},
E\eqn{(Y)=\mu} and Var\eqn{(Y)=\mu+\phi\mu^3}.

So, the regression models based on the negative binomial distributions are alternatives to the Poisson regression model
under the presence of overdispersion.

The beta-binomial distribution can be obtained as mixture of the binomial and Beta distributions. Let \eqn{mY | \pi} ~ Binomial\eqn{(m,\pi)}, where E\eqn{(Y | \pi)=\pi} and Var\eqn{(Y | \pi)=(1/m)\pi(1-\pi)},
and \eqn{\pi} ~ Beta\eqn{(\mu,\phi)}, where E\eqn{(\pi)=\mu} and Var\eqn{(\pi)=[\phi/(\phi+1)]\mu(1-\mu)}, then
\eqn{mY} ~ Beta Binomial\eqn{(m,\mu,\phi)}, E\eqn{(Y)=\mu} and
Var\eqn{(Y)=(1/m)\mu(1-\mu)[1 + (m-1)\phi/(\phi+1)]}.

So, the regression model based on the beta-binomial distribution is an alternative to the binomial regression model
under the presence of overdispersion.
}
\examples{
fit1 <- overglm(tumors ~ group, family="nb3(log)", data=mammary)
summary(fit1)

fit2 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
summary(fit2)

fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn + tnf*ifn, family="bb(logit)", data=cellular)
summary(fit3)

fit4 <- overglm(cbind(fetuses,litter-fetuses) ~ pht*tcpo, family="bb(logit)", data=ossification)
summary(fit4)

}
\references{
Lawless J.F. (1987) Negative binomial and mixed poisson regression, \emph{The Canadian Journal
of Statistics} 15, 209-225.

Crowder M. (1978) Beta-binomial anova for proportions, \emph{Journal of the Royal Statistical Society Series C (Applied Statistics)} 27, 34-37.
}
