% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{gen.binomial.data}
\alias{gen.binomial.data}
\title{Simulate a binomial data set}
\usage{
gen.binomial.data(n, p, rho = 0, kappa = 5, beta.type = 1, seed = 2021)
}
\arguments{
\item{n}{Sample size.}

\item{p}{Number of covariates.}

\item{rho}{The parameter defining the AR(1) correlation matrix.}

\item{kappa}{The number of nonzero coefficients.}

\item{beta.type}{Numeric indicator for choosing the beta type. For 
\code{beta.type = 1}, the true coefficient vector has \code{kappa} components being 1, 
roughly equally distributed between 1 to \code{p}. For \code{beta.type = 2}, 
the first \code{kappa} values are 1, and the rest are 0. For \code{beta.type = 3}, 
the first \code{kappa} values are equally-spaced values from 10 to 0.5, and 
the rest are 0. For \code{beta.type = 4}, the first \code{kappa} values are 
the first \code{kappa} values in c(-10, -6, -2, 2, 6, 10), and the rest are 
0. For \code{beta.type = 5}, the first \code{kappa} values are 1, and the 
rest decay exponentially to 0 with base 0.5.}

\item{seed}{The seed for reproducibility. Default is 2021.}
}
\value{
A list containing the simulated data.
\item{X}{the covariate matrix, of dimension \code{n} x \code{p}.}
\item{y}{the response, of length \code{n}.}
\item{beta}{the true coefficients, of length \code{p}.}
}
\description{
Simulate a data set with binary response following the logistic regression
  model.
}
\examples{
bin_data <- gen.binomial.data(n = 200, p = 20, seed = 2021)
head(bin_data$X)
head(bin_data$y)
head(bin_data$beta)

}
