% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgh.R, R/pgh.R, R/qgh.R, R/rgh.R
\name{dgh}
\alias{dgh}
\alias{g-and-h}
\alias{pgh}
\alias{qgh}
\alias{rgh}
\title{g-and-h distribution functions}
\usage{
dgh(x, A, B, g, h, c = 0.8, log = FALSE)

pgh(q, A, B, g, h, c = 0.8, zscale = FALSE)

qgh(p, A, B, g, h, c = 0.8)

rgh(n, A, B, g, h, c = 0.8)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{A}{Vector of A (location) parameters.}

\item{B}{Vector of B (scale) parameters. Must be positive.}

\item{g}{Vector of g parameters.}

\item{h}{Vector of h parameters. Must be non-negative.}

\item{c}{Vector of c parameters. Often fixed at 0.8 which is the default.}

\item{log}{If true the log density is returned.}

\item{q}{Vector of quantiles.}

\item{zscale}{If true the N(0,1) quantile of the cdf is returned.}

\item{p}{Vector of probabilities.}

\item{n}{Number of draws to make.}
}
\value{
\code{dgh} gives the density, \code{pgh} gives the distribution, \code{qgh} gives the quantile function, and \code{rgh} generates random deviates
}
\description{
Density, distribution function, quantile function and random generation for the generalised g-and-h distribution
}
\details{
The (generalised) g-and-h distribution is defined by its quantile function:
 \deqn{x(p) = A + B [1 + c \tanh(gz/2)] z \exp(hz^2/2),}{x(p) = A + B [1 + c tanh(gz/2)] z exp(hz^2/2),}
 where z is the standard normal quantile of p.
 Parameter restrictions include \deqn{B>0} and \deqn{h \geq 0}{h>=0}. Typically c=0.8. For more
 background information see the references.

\code{rgh} and \code{qgh} use quick direct calculations. However \code{dgh} and \code{pgh} involve slower numerical inversion of the quantile function.

Especially extreme values of the inputs will produce \code{pgh} output rounded to 0 or 1 (-Inf or Inf for \code{zscale=TRUE}).
The corresponding \code{dgh} output will be 0 or -Inf for \code{log=TRUE}.
}
\examples{
p = 1:9/10 ##Some probabilities
x = qgh(seq(0.1,0.9,0.1), A=3, B=1, g=2, h=0.5) ##g-and-h quantiles
rgh(5, A=3, B=1, g=2, h=0.5) ##g-and-h draws
dgh(x, A=3, B=1, g=2, h=0.5) ##Densities of x under g-and-h
dgh(x, A=3, B=1, g=2, h=0.5, log=TRUE) ##Log densities of x under g-and-h
pgh(x, A=3, B=1, g=2, h=0.5) ##Distribution function of x under g-and-h
}
\references{
Haynes `Flexible distributions and statistical models in ranking and selection procedures, with applications' PhD Thesis QUT (1998)
Rayner and MacGillivray `Numerical maximum likelihood estimation for the g-and-k and generalized g-and-h distributions' Statistics and Computing, 12, 57-75 (2002)
}

