% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationBeltUtilities.R
\name{calibrationBeltPoints}
\alias{calibrationBeltPoints}
\title{Calibration Belt Confidence Region}
\usage{
calibrationBeltPoints(data, seqG, m, fit, thres, cLevel, devel)
}
\arguments{
\item{data}{A \code{data.frame} object with the numeric variables "o", "e"
and "logite", representing the binary outcomes, the probabilities of the
model under evaluation and the logit of the probabilities, respectively.
The variable "e" must contain values between 0 and 1. The variable
"o" must assume only the values 0 and 1.}

\item{seqG}{A vector containing the logit of the probabilities where the points
of the calibration belt will be evaluated.}

\item{m}{A scalar integer representing the degree of the polynomial
at the end of the forward selection.}

\item{fit}{An object of class \code{glm} containig the output of the fit
of the logistic regression model at the end of the iterative
forward selection.}

\item{thres}{A numeric scalar between 0 and 1 representing 1 - the significance level
adopted in the forward selection.}

\item{cLevel}{A numeric scalar between 0 and 1 representing the confidence level
that will be used for the confidence region.}

\item{devel}{A character string specifying if the model has been fit on
the same dataset under evaluation (\code{internal}) or if the model has
been developed on an external sample (\code{external}).}
}
\value{
A \code{data.frame} object with two columns, "U" and "L", containing
the points of the upper and lower boundary of the \code{cLevel}*100\%-level calibration belt evaluated
at values \code{seqG}.
}
\description{
\code{calibrationBeltPoints} computes the points defining the boundary
of the confidence region.
}
\examples{
e <- runif(100)
logite <- logit(e)
o <- rbinom(100, size = 1, prob = e)
data <- data.frame(e = e, o = o, logite = logite)

seqG <- logit(seq(from = .01, to =.99, by = .01))

fwLR <- polynomialLogRegrFw(data, .95, 4, 1)

calibrationBeltPoints(data, seqG, fwLR$m, fwLR$fit, .95, .90, "external")
}
\seealso{
\code{\link{givitiCalibrationBelt}} and \code{\link{plot.givitiCalibrationBelt}}
 to compute and plot the calibaration belt, and
 \code{\link{givitiCalibrationTest}} to perform the
 associated calibration test.
}

