% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_class.R
\name{summary.gips}
\alias{summary.gips}
\alias{print.summary.gips}
\title{Summarizing the gips object}
\usage{
\method{summary}{gips}(object, ...)

\method{print}{summary.gips}(x, ...)
}
\arguments{
\item{object}{An object of class "gips"; is usually a result of a \code{\link[=find_MAP]{find_MAP()}}.}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{An object of class "summary.gips" to be printed}
}
\value{
The function \code{summary.gips} computes and returns a list of summary
statistics of the given \code{gips} object. Those are:
\itemize{
\item For unoptimized \code{gips} object:
\enumerate{
\item \code{optimized} - \code{FALSE}
\item \code{start_permutation} - the permutation this \code{gips} represents
\item \code{start_permutation_log_posteriori} - the log of the a posteriori
value the start permutation has
\item \code{times_more_likely_than_id} - how many more likely
the \code{start_permutation} is over the identity permutation, \verb{()}.
It can be a number less than 1, which means
the identity permutation, \verb{()}, is more likely. Keep in mind
this number can be really big and can be overflowed to \code{Inf}
\item \code{n0} - the minimal number of observations needed for existence of
the maximum likelihood estimator (corresponding to a MAP) of
the covariance matrix (see \strong{\eqn{C\sigma} and \code{n0}}
section in \code{vignette("Theory", package = "gips")} or in its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}).
\item \code{S_matrix} - the underlying matrix; this is used to calculate
the posteriori value
\item \code{number_of_observations} - the number of observations that
were observed for the \code{S_matrix} to be calculated; this is
used to calculate the posteriori value
\item \code{was_mean_estimated} - given by the user while creating the \code{gips} object:
\itemize{
\item \code{TRUE} means the \code{S} parameter was output of \code{\link[stats:cor]{stats::cov()}} function
\item \code{FALSE} means the \code{S} parameter was calculated with
\code{S = t(X) \%*\% X / number_of_observations}
}
\item \code{delta}, \code{D_matrix} - the parameters of the Bayesian method
}
\item For optimized \code{gips} object:
\enumerate{
\item \code{optimized} - \code{TRUE}
\item \code{found_permutation} - the permutation this \code{gips} represents;
the visited permutation with the biggest a posteriori value
\item \code{found_permutation_log_posteriori} - the log of the a posteriori
value the found permutation have
\item \code{start_permutation} - the original permutation this \code{gips}
represented before optimization; the first visited permutation
\item \code{start_permutation_log_posteriori} - the log of the a posteriori
value the start permutation has
\item \code{times_more_likely_than_start} - how many more likely
the \code{found_permutation} is over the \code{start_permutation}.
It cannot be a number less than 1. Keep in mind this number
can be really big and can be overflowed to \code{Inf}
\item \code{n0} - the minimal number of observations needed for existence of
the maximum likelihood estimator (corresponding to a MAP) of
the covariance matrix (see \strong{\eqn{C\sigma} and \code{n0}}
section in \code{vignette("Theory", package = "gips")} or in its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}).
\item \code{S_matrix} - the underlying matrix; this is used to calculate
the posteriori value
\item \code{number_of_observations} - the number of observations that
were observed for the \code{S_matrix} to be calculated; this is
used to calculate the posteriori value
\item \code{was_mean_estimated} - given by the user while creating the \code{gips} object:
\itemize{
\item \code{TRUE} means the \code{S} parameter was output of \code{\link[stats:cor]{stats::cov()}} function
\item \code{FALSE} means the \code{S} parameter was calculated with
\code{S = t(X) \%*\% X / number_of_observations}
}
\item \code{delta}, \code{D_matrix} - the parameters of the Bayesian method
\item \code{optimization_algorithm_used} - all used optimization algorithms
in order (one could start optimization with "MH", and then
do an "HC")
\item \code{did_converge} - a boolean, did the last used algorithm converge
\item \code{number_of_log_posteriori_calls} - how many times was
the \code{\link[=log_posteriori_of_gips]{log_posteriori_of_gips()}} function called during
the optimization
\item \code{whole_optimization_time} - how long was the optimization process;
the sum of all optimization times (when there were multiple)
\item \code{log_posteriori_calls_after_best} - how many times was
the \code{\link[=log_posteriori_of_gips]{log_posteriori_of_gips()}} function called after
the \code{found_permutation}; in other words, how long ago
could the optimization be stopped and have the same result;
if this value is small, consider running \code{\link[=find_MAP]{find_MAP()}}
one more time with \code{optimizer = "continue"}.
For \code{optimizer = "BF"}, it is \code{NULL}
\item \code{acceptance_rate} - only interesting for \code{optimizer = "MH"};
how often was the algorithm accepting the change of permutation
in an iteration
}
}

\code{print.summary.gips} returns an invisible \code{NULL}.
}
\description{
\code{summary} method for class "gips".
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(summary.gips)}: Printing method for class "summary.gips".
Prints every interesting information in a pleasant, human readable form

}}
\examples{
require("MASS") # for mvrnorm()

perm_size <- 6
mu <- runif(6, -10, 10) # Assume we don't know the mean
sigma_matrix <- matrix(
  data = c(
    1.0, 0.8, 0.6, 0.4, 0.6, 0.8,
    0.8, 1.0, 0.8, 0.6, 0.4, 0.6,
    0.6, 0.8, 1.0, 0.8, 0.6, 0.4,
    0.4, 0.6, 0.8, 1.0, 0.8, 0.6,
    0.6, 0.4, 0.6, 0.8, 1.0, 0.8,
    0.8, 0.6, 0.4, 0.6, 0.8, 1.0
  ),
  nrow = perm_size, byrow = TRUE
) # sigma_matrix is a matrix invariant under permutation (1,2,3,4,5,6)
number_of_observations <- 13
Z <- MASS::mvrnorm(number_of_observations, mu = mu, Sigma = sigma_matrix)
S <- cov(Z) # Assume we have to estimate the mean

g <- gips(S, number_of_observations)

g_map <- find_MAP(g, max_iter = 10, show_progress_bar = FALSE, optimizer = "Metropolis_Hastings")
unclass(summary(g_map))

g_map2 <- find_MAP(g, max_iter = 10, show_progress_bar = FALSE, optimizer = "hill_climbing")
summary(g_map2)
# ================================================================================
S <- matrix(c(1, 0.5, 0.5, 2), nrow = 2, byrow = TRUE)
g <- gips(S, 10)
\donttest{print(summary(g))}
}
\seealso{
\itemize{
\item \code{\link[=find_MAP]{find_MAP()}} - Usually, the \code{summary.gips()}
is called on the output of \code{find_MAP()}.
\item \code{\link[=log_posteriori_of_gips]{log_posteriori_of_gips()}} - The function that
calculates the likelihood of a permutation.
\item \code{\link[=project_matrix]{project_matrix()}} - The function that can project
the known matrix of the found permutations space.
}
}
