% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthlyComposite.R
\docType{methods}
\name{monthlyComposite}
\alias{monthlyComposite}
\alias{monthlyComposite,RasterStackBrick-method}
\alias{monthlyComposite,character-method}
\title{Calculate Monthly Composite Images}
\usage{
\S4method{monthlyComposite}{RasterStackBrick}(x, indices, fun = max,
  cores = 1L, filename = "", ...)

\S4method{monthlyComposite}{character}(x, version = 1L,
  pos1 = ifelse(version == 1, 15L, 4L), pos2 = ifelse(version == 1,
  23L, 8L), fun = max, cores = 1L, filename = "", ...)
}
\arguments{
\item{x}{Multi-layered \code{Raster*} object or \code{character} vector of
filenames. If the latter applies and 'pos1', 'pos2' are not specified, the
function will try to retrieve monthly indices from
\code{\link{monthlyIndices}}. Note that the specification of NDVI3g.v0 ENVI
binary files is hereby not allowed and in such a case,
\code{\link{rasterizeGimms}} should be run beforehand.}

\item{indices}{\code{numeric}. Indices to denote layers or files from
identical months.}

\item{fun}{\code{function}. Used to calculate monthly composite layers,
defaults to \code{\link{max}}. Note that a separate 'na.rm' argument is
passed down to \code{\link{stackApply}} via '...' and hence should not be
included here.}

\item{cores}{\code{integer}. Number of cores for parallel computing.}

\item{filename}{\code{character}. Optional output filename passed to
\code{\link{stackApply}}.}

\item{...}{Further arguments passed to \code{\link{stackApply}} (i.e.,
'na.rm') and its underlying \code{\link{writeRaster}} call.}

\item{version}{\code{integer} (or any other class convertible to
\code{integer}). Specifies GIMMS NDVI3g product version, see 'Details' in
\code{\link{updateInventory}}.}

\item{pos1, pos2}{\code{integer}. If 'x' is a vector of filenames, the first
and last element of the date string to build monthly indices from. Defaults
to the 'version'-specific NDVI3g naming convention, see
\code{\link{monthlyIndices}}.}
}
\value{
If \code{length(x) == 2}, a single \code{RasterLayer} object, else a
\code{RasterStack} object with monthly composite layers.
}
\description{
Based on a user-defined function, e.g. \code{max} for maximum value
composites (MVC), aggregate half-monthly GIMMS data sets to monthly composites.
}
\examples{
data("bale3g.v1")

## select layers from 1981 only
fls <- system.file("extdata/inventory_ecv1.rds", package = "gimms")
fls <- readRDS(fls)[1]
rst <- bale3g.v1[[1:12]]

## aggregate to monthly mvc layers
mvc <- monthlyComposite(rst, indices = monthlyIndices(fls))

}
\seealso{
\code{\link{stackApply}}, \code{\link{monthlyIndices}},
\code{\link{writeRaster}}.
}
