% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R, R/action_runs.R, R/action_status.R,
%   R/action_workflows.R
\name{action}
\alias{action}
\alias{action_runs}
\alias{action_status}
\alias{action_workflows}
\title{Retrieve information about GitHub Actions workflows and their runs.}
\usage{
action_runs(repo, limit = 50)

action_status(repo, branch = NULL, before = NULL, limit = 50)

action_workflows(repo, full = FALSE)
}
\arguments{
\item{repo}{Character. Address of repository in \code{owner/name} format.}

\item{limit}{Numeric. Maximum number of workflow runs to return.}

\item{branch}{Character. Vector of branches to report. Default \code{NULL}, returns all branches.}

\item{before}{Datetime. Remove all runs created after this timestamp.
Character values are converted using \code{lubridate::ymd_hms()}.}

\item{full}{Logical. Should all workflow columns be returned. Default \code{FALSE}.}
}
\value{
\code{action_workflows()}, \code{action_runs()}, and \code{action_status()} all return
tibbles containing information on requested repos' available workflows,
recent action runs, and recent action run statuses respectively.
}
\description{
\itemize{
\item \code{action_workflows()} - retrieve details on repo workflows.
\item \code{action_runs()} - retrieve details on repo workflow runs.
\item \code{action_status()} - retrieve details on most recent workflow runs.
}
}
\examples{
\dontrun{
action_workflows("rundel/ghclass")

action_runs("rundel/ghclass")

action_status(c("rundel/ghclass", "rundel/parsermd"))
}

}
