% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-novar-tern.R
\name{theme_novar_tern}
\alias{theme_novar_tern}
\title{Blank one variable's annotations in ternary plot}
\usage{
theme_novar_tern(species, \dots)
}
\arguments{
\item{species}{A character giving the species. Choices are "T", "L" and "R", but is not case sensitive}

\item{\dots}{Further arguments, including additional selections otherwise used in species}
}
\value{
This function is called for the side effect of adding a theme which actually blanks
the grid and axis elements for the chosen ternary species.
}
\description{
This function blanks the grid and axis elements for one variable in a ternary plot.
}
\details{
This function takes a user-specified character corresponding to one of the three
ternary variables, and constructs a \code{theme} function which adds blank elements
for that variable's grid elements and axis elements chosen from the \pkg{ggtern}
package.  This new function is then executed which "adds" this theme to the open
ternary plot.

The logic of the species selection is pretty transparent so it may be possible to
customize this function to add further affected elements as desired.  However the
computing on the language which drives this function has not been thoroughly
tested.  Neither has this function been tested with non-ternary plots available in
the \pkg{ggplot2} framework.
}
\examples{
base = ggtern() + theme_rgbg()
base + theme_novar_tern("L")
base + theme_novar_tern(c("T","L"))
base + theme_novar_tern('L',R)

}
\author{
Nicholas Hamilton, John Szumiloski
}

