% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit2_p.R
\name{survfit2_p}
\alias{survfit2_p}
\title{Calculate p-value}
\usage{
survfit2_p(x, pvalue_fun = format_p, prepend_p = TRUE, ...)
}
\arguments{
\item{x}{a 'survfit2' object}

\item{pvalue_fun}{function to round and style p-value with}

\item{prepend_p}{prepend \code{"p="} to formatted p-value}

\item{...}{
  Arguments passed on to \code{\link[survival:survdiff]{survival::survdiff}}
  \describe{
    \item{\code{subset}}{
expression indicating which subset of the rows of data should be used in
the fit.  This can be a logical vector (which is replicated to have
length equal to the number of observations), a numeric vector indicating
which observation numbers are to be included (or excluded if negative),
or a character vector of row names to be included.  All observations are
included by default.
}
    \item{\code{na.action}}{
a missing-data filter function.  This is applied to the \code{model.frame} after any
subset argument has been used.  Default is \code{options()$na.action}.
}
    \item{\code{rho}}{
a scalar parameter that controls the type of test.
}
    \item{\code{timefix}}{process times through the \code{aeqSurv} function to
  eliminate potential roundoff issues.}
  }}
}
\value{
a string
}
\description{
The function \code{survfit2_p()} wraps \code{survival::survdiff()} and returns
a formatted p-value.
}
\examples{
library(ggplot2)

sf <- survfit2(Surv(time, status) ~ sex, data = df_lung)

sf \%>\%
  ggsurvfit() +
  add_confidence_interval() +
  add_risktable() +
  labs(caption = glue::glue("Log-rank {survfit2_p(sf)}"))

sf \%>\%
  ggsurvfit() +
  add_confidence_interval() +
  add_risktable() +
  annotate("text", x = 2, y = 0.05, label = glue::glue("{survfit2_p(sf)}"))
}
