% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_stats.R
\name{extract_stats}
\alias{extract_stats}
\title{Extracting data frames from \code{{ggstatsplot}} plots}
\usage{
extract_stats(p, ...)
}
\arguments{
\item{p}{A plot from \code{{ggstatsplot}} package}

\item{...}{Ignored}
}
\value{
A list of tibbles containing summaries of various statistical analyses.
}
\description{
Extracting data frames from \code{{ggstatsplot}} plots
}
\details{
This is a convenience function to extract data frames with statistical details
that are used to create expressions displayed in \code{{ggstatsplot}} plots as
subtitle, caption, etc. Note that all of this analysis is carried out by
the \code{{statsExpressions}} \href{https://indrajeetpatil.github.io/statsExpressions/}{package}.

The only exception is the \code{ggcorrmat()} function. But, if a data frame is
what you want, you shouldn't be using \code{ggcorrmat()} anyway. You can use
\code{correlation::correlation()} function which provides tidy data frames by
default. This also works if the data entered is grouped (\emph{a la}
\code{dplyr::group_by()}). This is also the function used internally by
\code{{ggstatsplot}} to extract a data frame used to create a plot.
}
\examples{
\donttest{
if (require("PMCMRplus")) {
  set.seed(123)
  library(ggstatsplot)

  # in case of group comparisons
  p <- ggbetweenstats(mtcars, cyl, mpg)
  extract_stats(p)

  # the exact details depend on the function
  extract_stats(ggbarstats(mtcars, cyl, am))
}
}
}
