context("theme_ggstatsplot")

# `theme_ggstatsplot()` works --------------------------------------------------

testthat::test_that(
  desc = "`theme_ggstatsplot()` works",
  code = {
    set.seed(123)
    library(ggplot2)

    # plot
    p <-
      ggplot(msleep, aes(vore, brainwt)) + geom_point(na.rm = TRUE)

    # changing the basic plot
    p1 <- p +
      ggstatsplot::theme_ggstatsplot(ggstatsplot.layer = FALSE)
    p2 <- p +
      ggstatsplot::theme_ggstatsplot(ggplot2::theme_dark())
    p3 <- p +
      ggstatsplot::theme_ggstatsplot(ggplot2::theme_minimal())

    # check if outputs are ggplot objects
    testthat::expect_identical(class(p1), c("gg", "ggplot"))
    testthat::expect_identical(class(p2), c("gg", "ggplot"))
    testthat::expect_identical(class(p3), c("gg", "ggplot"))
  }
)


# `theme_pie()` works --------------------------------------------------

testthat::test_that(
  desc = "`theme_pie()` works",
  code = {
    set.seed(123)
    library(ggplot2)

    df1 <- tibble::enframe(ggstatsplot::theme_pie())
    df2 <-
      tibble::enframe(ggstatsplot::theme_pie(ggtheme = theme_classic()), FALSE)
    df3 <- tibble::enframe(ggstatsplot::theme_pie(
      ggtheme = ggplot2::theme_bw(),
      ggstatsplot.layer = FALSE
    ))

    testthat::expect_is(df1, "tbl_df")
    testthat::expect_is(df2, "tbl_df")
    testthat::expect_is(df3, "tbl_df")
    testthat::expect_is(df1$value, "theme")
    testthat::expect_is(df2$value, "gg")
    testthat::expect_is(df3$value, "theme")
  }
)
