% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_one_sample_ttest}
\alias{bf_one_sample_ttest}
\title{Bayesian one-sample \emph{t}-test.}
\usage{
bf_one_sample_ttest(data = NULL, x, test.value = 0, bf.prior = 0.707,
  caption = NULL, output = "caption", k = 2, ...)
}
\arguments{
\item{data}{for use with \code{formula}, a data frame containing all the
data}

\item{x}{a vector of observations for the first (or only) group}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"caption"} (which will contain text for evidence
in favor of null)  or \code{"results"} (which will return the dataframe with
results).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Bayesian one-sample \emph{t}-test.
}
\examples{

# to get caption (default)
bf_one_sample_ttest(
  data = iris,
  x = Sepal.Length,
  test.value = 5.85,
  bf.prior = 0.8,
  output = "caption", k = 2
)

# to get results dataframe
bf_one_sample_ttest(
  data = iris,
  x = Sepal.Length,
  test.value = 5.85,
  bf.prior = 0.8,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_two_sample_ttest}}
}
\author{
Indrajeet Patil
}
