% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats.R
\name{outlier_df}
\alias{outlier_df}
\title{Adding a column to dataframe describing outlier status.}
\usage{
outlier_df(data, x, y, outlier.label, outlier.coef = 1.5, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{outlier.label}{Label to put on the outliers that have been tagged.}

\item{outlier.coef}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}

\item{...}{Additional arguments.}
}
\description{
This function is mostly helpful for internal operations of some
of the functions in this package.
}
\examples{
# adding column for outlier and a label for that outlier
ggstatsplot:::outlier_df(
  data = morley,
  x = Expt,
  y = Speed,
  outlier.label = Run,
  outlier.coef = 2
) \%>\%
  dplyr::arrange(outlier)
}
\author{
Indrajeet Patil
}
\keyword{internal}
