% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-wlength.R
\name{sec_axis_w_number}
\alias{sec_axis_w_number}
\alias{sec_axis_w_frequency}
\title{Secondary axes for wavelengths}
\usage{
sec_axis_w_number(unit.exponent = -6, label.text = axis_labels()[["w.number"]])

sec_axis_w_frequency(unit.exponent = 12, label.text = axis_labels()[["freq"]])
}
\arguments{
\item{unit.exponent}{integer}

\item{label.text}{character Textual portion of the labels.}
}
\description{
Secondary axes for wavelength data in nanometres. With suitable scaling and
name (axis label) for frequency and wavenumber.
}
\examples{

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number())

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number(-4))

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number(nearest_SI_exponent(-4)))

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_number(-3))

ggplot(sun.spct) +
  geom_line() +
  scale_x_continuous(name = w_length_label(),
                     sec.axis = sec_axis_w_frequency())

}
