% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-waveband.r
\name{plot.waveband}
\alias{plot.waveband}
\title{Plot a waveband as a spectrum.}
\usage{
\method{plot}{waveband}(x, ..., w.length = NULL, range = c(280, 800),
  fill = 0, unit.in = getOption("photobiology.radiation.unit", default =
  "energy"), annotations = getOption("photobiology.plot.annotations", default
  = c("colour.guide", "boxes", "labels")), wb.trim = TRUE, norm = NULL)
}
\arguments{
\item{x}{a waveband object}

\item{...}{other arguments passed to plot.response_spct()}

\item{w.length}{numeric vector of wavelengths (nm)}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{fill}{value to use as response for wavelngths outside the waveband
range}

\item{unit.in}{the type of unit we assume as reference "energy" or "photon"
based}

\item{annotations}{a character vector}

\item{wb.trim}{logical}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
waveband object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot object, and can be further manipulated.

Effectiveness spectra are plotted expressing the spectral effectiveness
either as $1 mol^{-1} nm$ photons of $1 J^{-1} nm$ which can selected through
formal argument \code{unit.out}. The value of \code{unit.in} has no effect on
the result when uisng BSWFs, as BSWFs are defined based on a certain base of
expression, which is enforced. In contrast, for wavebands which only define a
wavelength range, changing the assumed reference irradiance, changes the
responsivity according to Plank's law.

This function creates a response_spct object from the waveband object and
plots it. Unused arguments are passed along, which means that other plot
aspects can be controlled by providing arguments for the plot method of the
response_spct class.
}
\examples{
library(photobiology)
plot(waveband(c(400, 500)))

}
\seealso{
Other plot functions: \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}}
}
\keyword{hplot}

