% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-spatial.R
\name{layer_spatial}
\alias{layer_spatial}
\alias{annotation_spatial}
\alias{layer_spatial.default}
\alias{annotation_spatial.default}
\alias{shadow_spatial}
\alias{shadow_spatial.default}
\title{Turn a spatial object into a ggplot2 layer}
\usage{
layer_spatial(data, mapping, ...)

annotation_spatial(data, mapping, ...)

\method{layer_spatial}{default}(
  data,
  mapping = aes(),
  inherit.aes = FALSE,
  sf_params = list(),
  ...
)

\method{annotation_spatial}{default}(
  data,
  mapping = aes(),
  inherit.aes = FALSE,
  sf_params = list(),
  ...
)

shadow_spatial(data, ...)

\method{shadow_spatial}{default}(data, ...)
}
\arguments{
\item{data}{An object that can be coerced to an sf object using \link[sf:st_as_sf]{st_as_sf}.}

\item{mapping}{A mapping, created using \link[ggplot2:aes]{aes}.}

\item{...}{Passed to \link[ggplot2:ggsf]{geom_sf}}

\item{inherit.aes}{Inherit aesthetics from ggplot()?}

\item{sf_params}{Passed to \link[sf:st_as_sf]{st_as_sf}.}
}
\value{
A ggplot2 \link[ggplot2:layer]{layer}.
}
\description{
See also \code{\link[=layer_spatial.Raster]{layer_spatial.Raster()}}, \code{\link[=layer_spatial.stars]{layer_spatial.stars()}},
\code{\link[=layer_spatial.SpatRaster]{layer_spatial.SpatRaster()}} and \code{\link[=layer_spatial.bbox]{layer_spatial.bbox()}} for implementations
for other types of spatial objects.
}
\examples{
\donttest{
library(ggplot2)
load_longlake_data(
  which = c(
    "longlake_roadsdf",
    "longlake_depthdf",
    "longlake_depth_raster"
  )
)

ggplot() +

  # annotation_spatial() layers don't train the scales, so data stays central
  annotation_spatial(longlake_roadsdf, size = 2, col = "black") +
  annotation_spatial(longlake_roadsdf, size = 1.6, col = "white") +

  # raster layers train scales and get projected automatically
  layer_spatial(longlake_depth_raster, aes(alpha = after_stat(band1)), fill = "darkblue") +
  scale_alpha_continuous(na.value = 0) +

  # layer_spatial() layers train the scales
  layer_spatial(longlake_depthdf, aes(col = DEPTH_M)) +

  # spatial-aware automagic scale bar
  annotation_scale(location = "tl") +

  # spatial-aware automagic north arrow
  annotation_north_arrow(location = "br", which_north = "true")
}

}
