% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stl-seasonal.R
\name{stat_stl}
\alias{stat_stl}
\title{LOESS seasonal adjustment Stat}
\usage{
stat_stl(mapping = NULL, data = NULL, geom = "line",
  position = "identity", show.legend = NA, inherit.aes = TRUE, frequency,
  s.window, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{frequency}{The frequency for the time series}

\item{s.window}{either the character string \code{"periodic"} or the span (in lags) of the 
loess window for seasonal extraction, which should be odd and at least 7, according to
Cleveland et al.  This has no default and must be chosen.}

\item{...}{other arguments for the geom}
}
\description{
Conducts seasonal adjustment on the fly for ggplot2, from LOESS seasonal decomposition
}
\examples{
ap_df <- tsdf(AirPassengers)

# periodic if fixed seasonality; doesn't work well:
ggplot(ap_df, aes(x = x, y = y)) +
   stat_stl(frequency = 12, s.window = "periodic")

# seasonality varies a bit over time, works better:
ggplot(ap_df, aes(x = x, y = y)) +
   stat_stl(frequency = 12, s.window = 7)

ggplot(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex)) +
geom_point() +
  facet_wrap(~sex) +
stat_stl(frequency = 12, s.window = 7) +
   ggtitle("Seasonally adjusted lung deaths")

}
\seealso{
Other time.series.stats.for.ggplot2: \code{\link{stat_decomp}},
  \code{\link{stat_seas}}
}

