% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgraph.R
\name{qgraph}
\alias{qgraph}
\title{Quickplot wrapper for networks}
\usage{
qgraph(graph, node_colour = NULL, edge_colour = NULL,
  node_size = NULL, edge_width = NULL, node_label = NULL,
  edge_label = NULL)
}
\arguments{
\item{graph}{An object coercible to a tbl_graph}

\item{node_colour, edge_colour}{Colour mapping for nodes and edges}

\item{node_size, edge_width}{Size/width mapping for nodes and edges}

\item{node_label, edge_label}{Label mapping for nodes and edges}
}
\description{
This function is intended to quickly show an overview of your network data.
While it returns a ggraph object that layers etc can be added to it is
limited in use and should not be used as a foundation for more complicated
plots. It allows colour, labeling and sizing of nodes and edges, and the
exact combination of layout and layers will depend on these as well as the
features of the network. The output of this function may be fine-tuned at any
release and should not be considered stable. If a plot should be reproducible
it should be created manually.
}
\examples{
library(tidygraph)
gr <- create_notable('herschel') \%>\%
  mutate(class = sample(letters[1:3], n(), TRUE)) \%E>\%
  mutate(weight = runif(n()))

# Standard graph
qgraph(gr)

# Adding node labels will cap edges
qgraph(gr, node_label = class)

# Use tidygraph calls for mapping
qgraph(gr, node_size = centrality_pagerank())

# Trees are plotted as dendrograms
iris_tree <- hclust(dist(iris[1:4], method = 'euclidean'), method = 'ward.D2')
qgraph(iris_tree)

}
