\name{geom_step}
\alias{geom_step}
\alias{GeomStep}
\title{geom\_step}
\description{Connect observations by stairs}
\details{
Equivalent to plot(type='s').This page describes geom\_step, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_step.  Aesthetics are mapped to variables in the data with the aes function: \code{geom\_step(aes(x = var))}
\itemize{
  \item \code{colour}: border colour 
  \item \code{size}: size 
  \item \code{linetype}: line type 
  \item \code{alpha}: transparency 
}
}
\usage{geom_step(mapping = NULL, data = NULL, stat = "identity", position = "identity", 
    direction = "hv", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{direction}{direction of stairs: 'vh' for vertical then horizontal, or 'hv' for horizontal then vertical}
 \item{...}{other arguments}
}
\seealso{\itemize{
  \item \url{http://had.co.nz/ggplot2/geom_step.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
# Simple quantiles/ECDF from examples(plot)
x <- sort(rnorm(47))
qplot(seq_along(x), x, geom="step")

# Steps go horizontally, then vertically (default)
qplot(seq_along(x), x, geom="step", direction = "hv")
plot(x, type = "s")
# Steps go vertically, then horizontally
qplot(seq_along(x), x, geom="step", direction = "vh")
plot(x, type = "S")

# Also works with other aesthetics
df <- data.frame(
  x = sort(rnorm(50)),
  trt = sample(c("a", "b"), 50, rep = T)
)
qplot(seq_along(x), x, data = df, geom="step", colour = trt)

}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
