% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPedigree.R
\name{plotPedigree}
\alias{plotPedigree}
\title{plotPedigree
A wrapped function to plot simulated pedigree from function \code{simulatePedigree}. This function require the installation of package \code{kinship2}.}
\usage{
plotPedigree(
  ped,
  code_male = NULL,
  verbose = FALSE,
  affected = NULL,
  cex = 0.5,
  col = 1,
  symbolsize = 1,
  branch = 0.6,
  packed = TRUE,
  align = c(1.5, 2),
  width = 8,
  density = c(-1, 35, 65, 20),
  mar = c(2.1, 1, 2.1, 1),
  angle = c(90, 65, 40, 0),
  keep.par = FALSE,
  pconnect = 0.5,
  ...
)
}
\arguments{
\item{ped}{The simulated pedigree data.frame from function \code{simulatePedigree}. Or a pedigree dataframe with the same colnames as the dataframe simulated from function \code{simulatePedigree}.}

\item{code_male}{This optional input allows you to indicate what value in the sex variable codes for male. Will be recoded as "M" (Male). If \code{NULL}, no recoding is performed.}

\item{verbose}{logical  If TRUE, prints additional information. Default is FALSE.}

\item{affected}{This optional parameter can either be a string specifying the column name that indicates affected status or a numeric/logical vector of the same length as the number of rows in 'ped'. If \code{NULL}, no affected status is assigned.}

\item{cex}{The font size of the IDs for each individual in the plot.}

\item{col}{The color of the symbols in the plot.}

\item{symbolsize}{The size of the symbols in the plot.}

\item{branch}{The length of the branches in the plot.}

\item{packed}{logical. If TRUE, the pedigree is drawn in a more compact form.}

\item{align}{A numeric vector of length 2 indicating the alignment penalties for parents and spouses.}

\item{width}{The width of the plot.}

\item{density}{A numeric vector indicating the shading density for different affected statuses.}

\item{mar}{A numeric vector of length 4 indicating the margins of the plot.}

\item{angle}{A numeric vector indicating the shading angles for different affected statuses.}

\item{keep.par}{logical. If TRUE, the current graphical parameters are preserved.}

\item{pconnect}{A numeric value indicating the proportion of the pedigree to connect.}

\item{...}{Additional arguments passed to \code{kinship2::plot.pedigree}}
}
\value{
A plot of the provided pedigree
}
\description{
plotPedigree
A wrapped function to plot simulated pedigree from function \code{simulatePedigree}. This function require the installation of package \code{kinship2}.
}
