% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPhenotypeByDegree.R
\name{ggPhenotypeByDegree.core}
\alias{ggPhenotypeByDegree.core}
\title{Core plotting function for ggPhenotypeByDegree
This function generates the core ggplot object based on the prepared data frame.}
\usage{
ggPhenotypeByDegree.core(
  df,
  y_var,
  y_se,
  y_stem_se,
  y_ci_lb = NULL,
  y_ci_ub = NULL,
  config,
  ...
)
}
\arguments{
\item{df}{Data frame containing pairwise summary statistics. Required columns:
\describe{
   \item{addRel_min}{Minimum relatedness per group}
   \item{addRel_max}{Maximum relatedness per group}
   \item{n_pairs}{Number of pairs at that relatedness}
   \item{cnu}{Indicator for shared nuclear environment (1 = yes, 0 = no)}
   \item{mtdna}{Indicator for shared mitochondrial DNA (1 = yes, 0 = no)}
   }}

\item{y_var}{Name of the y-axis variable column (e.g., "r_pheno_rho").}

\item{y_se}{Name of the standard error column (e.g., "r_pheno_se").}

\item{y_stem_se}{Optional; base stem used to construct SE ribbon bounds. (e.g., "r_pheno")}

\item{y_ci_lb}{Optional; lower bound for confidence interval (e.g., "r_pheno_ci_lb").}

\item{y_ci_ub}{Optional; upper bound for confidence interval (e.g., "r_pheno_ci_ub").}

\item{config}{A list of configuration overrides. Valid entries include:
 \describe{
    \item{filter_n_pairs}{Minimum number of pairs to include (default: 500)}
    \item{filter_degree_min}{Minimum degree of relatedness (default: 0)}
    \item{filter_degree_max}{Maximum degree of relatedness (default: 7)}
    \item{plot_title}{Plot title}
    \item{plot_subtitle}{Plot subtitle}
    \item{color_scale}{Paletteer color scale name (e.g., "ggthemes::calc")}
    \item{use_only_classic_kin}{If TRUE, only classic kin are shown}
    \item{group_by_kin}{If TRUE, use classic kin × mtDNA for grouping}
    \item{drop_classic_kin}{If TRUE, remove classic kin rows}
    \item{drop_non_classic_sibs}{If TRUE, remove non-classic sibs (default: TRUE)}
    \item{annotate_include}{If TRUE, annotate mother/father/sibling points}
    \item{annotate_x_shift}{Relative x-axis shift for annotations}
    \item{annotate_y_shift}{Relative y-axis shift for annotations}
    \item{point_size}{Size of geom_point points (default: 1)}
    \item{use_relative_degree}{If TRUE, x-axis uses degree-of-relatedness scaling}
    \item{grouping_column}{Grouping column name (default: mtdna_factor)}
    \item{value_rounding_digits}{Number of decimal places for rounding (default: 2)}
    \item{match_threshold_percent}{Tolerance \% for matching known degrees}
    \item{max_degree_levels}{Maximum number of degrees to consider}
}}

\item{...}{Additional arguments passed to `ggplot2` functions.}
}
\value{
A ggplot object containing the correlation plot.
}
\description{
Core plotting function for ggPhenotypeByDegree
This function generates the core ggplot object based on the prepared data frame.
}
\keyword{internal}
