% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-hue.R, R/zxx.r
\name{scale_pattern_colour_hue}
\alias{scale_pattern_colour_hue}
\alias{scale_pattern_fill_hue}
\alias{scale_pattern_fill2_hue}
\alias{scale_pattern_colour_discrete}
\alias{scale_pattern_fill_discrete}
\alias{scale_pattern_fill2_discrete}
\alias{scale_pattern_color_discrete}
\alias{scale_pattern_color_hue}
\title{Evenly spaced colours for discrete data}
\usage{
scale_pattern_colour_hue(
  ...,
  h = c(0, 360) + 15,
  c = 100,
  l = 65,
  h.start = 0,
  direction = 1,
  na.value = "grey50",
  aesthetics = "pattern_colour"
)

scale_pattern_fill_hue(
  ...,
  h = c(0, 360) + 15,
  c = 100,
  l = 65,
  h.start = 0,
  direction = 1,
  na.value = "grey50",
  aesthetics = "pattern_fill"
)

scale_pattern_fill2_hue(
  ...,
  h = c(0, 360) + 15,
  c = 100,
  l = 65,
  h.start = 0,
  direction = 1,
  na.value = "grey50",
  aesthetics = "pattern_fill2"
)
}
\arguments{
\item{h, c, l, h.start, direction, ...}{See \code{ggplot2::scale_colour_hue}}

\item{na.value}{Colour to use for missing values}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
This is the default colour scale for categorical variables. It maps each
level to an evenly spaced hue on the colour wheel. It does not generate
colour-blind safe palettes.
}
\examples{
  if (require("ggplot2")) {
    df <- data.frame(level = c("a", "b", "c", "d"),
                     outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_hue()
    plot(gg)
  }
}
