% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-nodes.R
\name{geom_nodetext}
\alias{geom_nodetext}
\alias{geom_nodelabel}
\title{Label the nodes of a network.}
\usage{
geom_nodetext(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_nodelabel(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointy specified with
\code{nudge_x} or \code{nudge_y}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}
}
\description{
All arguments to these geoms are identical to those of
\code{\link[ggplot2]{geom_text}} and \code{\link[ggplot2]{geom_label}}.
}
\examples{
## geom_nodetext examples

if (require(network) && require(sna)) {
  n <- network(rgraph(10, tprob = 0.2), directed = FALSE)

  # just node labels
  ggplot(n, aes(x, y)) +
    geom_nodetext(aes(label = vertex.names)) +
    theme_blank()

  # with nodes underneath
  ggplot(n, aes(x, y)) +
    geom_nodes(colour = "gold", size = 9) +
    geom_nodetext(aes(label = vertex.names)) +
    theme_blank()

  # with nodes and edges
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "gold") +
    geom_nodes(colour = "gold", size = 9) +
    geom_nodetext(aes(label = vertex.names)) +
    theme_blank()
}


## geom_nodelabel examples

if (require(network) && require(sna)) {
  data(flo, package = "network")
  n <- network(flo, directed = FALSE)

  # with text labels
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "grey50") +
    geom_nodelabel(aes(label = vertex.names)) +
    theme_blank()

  # with text labels coloured according to degree centrality
  n \%v\% "degree" <- degree(n)
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "grey50") +
    geom_nodelabel(aes(label = vertex.names, fill = degree)) +
    scale_fill_gradient(low = "gold", high = "tomato") +
    theme_blank()

  # label only a subset of all nodes
  high_degree <- function(x) {
    x[ x$degree > median(x$degree), ]
  }
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "steelblue") +
    geom_nodes(aes(size = degree), colour = "steelblue") +
    geom_nodelabel(aes(label = vertex.names),
      data = high_degree,
      colour = "white", fill = "tomato"
    ) +
    theme_blank()
}

}
