% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_effective.R
\name{ggs_effective}
\alias{ggs_effective}
\title{Dotplot of the effective number of independent draws}
\usage{
ggs_effective(D, family = NA, greek = FALSE)
}
\arguments{
\item{D}{Data frame whith the simulations}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a dotplot of the effective number of independent draws. The version from the third edition of Bayesian Data Analysis (Gelman, Carlin, Stein, Dunson, Vehtari and Rubin) is used.
}
\details{
Notice that at least two chains are required.
}
\examples{
data(linear)
ggs_effective(ggs(s))
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09

Gelman, Carlin, Stern, Dunson, Vehtari and Rubin (2014) Bayesian Data Analysis. 3rd edition. Chapman & Hall/CRC, Boca Raton.
}
