% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_ribbon_interactive.R
\name{geom_ribbon_interactive}
\alias{geom_ribbon_interactive}
\alias{geom_area_interactive}
\title{Create interactive ribbons and area plots}
\usage{
geom_ribbon_interactive(...)

geom_area_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link{interactive_parameters}}.}
}
\description{
The geometries are based on \code{\link[ggplot2]{geom_ribbon}}
and \code{\link[ggplot2]{geom_area}}.
See the documentation for those functions for more details.
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
  \item As aesthetics with the mapping argument (via \code{\link[ggplot2]{aes}}).
  In this way they can be mapped to data columns and apply to a set of geometries.

  \item As plain arguments into the geom_*_interactive function (see
  \code{\link[ggplot2]{layer}}). In this way they can be set to a scalar value.
}
}

\examples{
# add interactive bar -------
library(ggplot2)
library(ggiraph)

# Generate data
huron <- data.frame(year = 1875:1972, level = as.vector(LakeHuron))
h <- ggplot(huron, aes(year))

g <- h +
  geom_ribbon_interactive(aes(ymin = level - 1, ymax = level + 1),
                          fill = "grey70", tooltip = "ribbon1", data_id="ribbon1",
                          hover_css = "stroke:red;stroke-width:inherit;") +
  geom_line_interactive(aes(y = level), tooltip = "level", data_id="line1",
                        hover_css = "stroke:orange;fill:none;")
x <- girafe(ggobj = g)
x <- girafe_options(x = x,
                    opts_hover(css = "fill:blue;stroke:orange;stroke-width:3px;") )
if( interactive() ) print(x)


g <- h + geom_area_interactive(aes(y = level), tooltip = "area1")
x <- girafe(ggobj = g)
if( interactive() ) print(x)
}
\seealso{
\code{\link{girafe}}
}
